// All packet types handled by the game should be >= 64.
#define DDPT_HELLO 0
#define DDPT_OK 1
#define DDPT_CANCEL 2
#define DDPT_COMMANDS 32
#define DDPT_FIRST_GAME_EVENT 64
#define DDPT_MESSAGE 67

// Packet types.
// PKT = sent by anybody
// PSV = sent by server
// PCL = sent by client
enum {
    // Messages and responses.
    PCL_HELLO = 0,
    PKT_OK = 1,
    PKT_CANCEL = 2,                 // unused?
    PKT_PLAYER_INFO = 3,
    PKT_CHAT = 4,
    PKT_TICCMD = 5,                 // unused?
    PKT_PING = 6,
    PSV_HANDSHAKE = 7,
    PSV_SERVER_CLOSE = 8,
    PSV_FRAME = 9,                  // obsolete
    PSV_PLAYER_EXIT = 10,
    PSV_CONSOLE_TEXT = 11,
    PCL_ACK_SHAKE = 12,
    PSV_SYNC = 13,
    PSV_FILTER = 14,                // unused?
    PKT_COMMAND = 15,               // obsolete
    PKT_LOGIN = 16,
    PCL_ACK_SETS = 17,
    PKT_COORDS = 18,
    PKT_DEMOCAM = 19,
    PKT_DEMOCAM_RESUME = 20,
    PCL_HELLO2 = 21,                // Includes game ID
    PSV_FRAME2 = 22,                // Frame packet v2
    PSV_FIRST_FRAME2 = 23,          // First PSV_FRAME2 after map change
    PSV_SOUND2 = 24,                // unused?
    PSV_STOP_SOUND = 25,
    PCL_ACKS = 26,
    PSV_PLAYER_FIX = 27,            // Fix angles/pos/mom.
    PCL_ACK_PLAYER_FIX = 28,        // Acknowledge player fix. /* 28 */
    PKT_COMMAND2 = 29,

    PCL_COMMANDS = DDPT_COMMANDS,   // 32; ticcmds (handled by game)

    // Game specific events.
    PKT_GAME_MARKER = DDPT_FIRST_GAME_EVENT // 64
};

// Game packet types. (DON'T CHANGE THESE)
enum {
    GPT_GAME_STATE = DDPT_FIRST_GAME_EVENT,
    GPT_WEAPON_FIRE,
    GPT_PLANE_MOVE,
    GPT_MESSAGE,                   // Non-chat messages.
    GPT_CONSOLEPLAYER_STATE,
    GPT_PLAYER_STATE,
    GPT_PSPRITE_STATE,
    GPT_SOUND,
    GPT_SECTOR_SOUND,
    GPT_FLOOR_MOVE_SOUND,
    GPT_CEILING_MOVE_SOUND,
    GPT_INTERMISSION,
    GPT_FINALE,
    GPT_PLAYER_INFO,
    GPT_SAVE,
    GPT_LOAD,
    GPT_CLASS,                     // jHexen: player class notification.
    GPT_CONSOLEPLAYER_STATE2,
    GPT_PLAYER_STATE2,
    GPT_YELLOW_MESSAGE,            // jHexen: yellow message.
    GPT_PAUSE,
    GPT_FINALE2,
    GPT_CHEAT_REQUEST,
    GPT_JUMP_POWER,                // Jump power (0 = no jumping)
    GPT_ACTION_REQUEST,
};
