#pragma once

#include <windows.h>
#include <D3D9Types.h>
#include <D3dumddi.h>
#include <d3dkmthk.h>

struct NvEscapeHeader {
  DWORD magic;
  WORD unknown_4;
  WORD unknown_6;
  DWORD size;
  DWORD magic2;
  DWORD code;
  DWORD unknown[7];
};

struct NvPrivateHeader {
	DWORD magic;
	WORD unknown_4;
	WORD unknown_6;
	DWORD unknown_8;
	DWORD size;
};

static_assert(sizeof(NvEscapeHeader) == 0x30, "sizeof(NvEscapeHeader)");
static_assert(sizeof(NvPrivateHeader) == 0x10, "sizeof(NvPrivateHeader)");

#pragma pack(push, 1)
template <typename T>
struct NvEscape {
  NvEscapeHeader header;
  T data;

  NvEscape(DWORD code, DWORD magic2) {
    memset(&header, 0, sizeof(header));
    memset(&data, 0, sizeof(data));

    header.magic = 0x4e564441;
    header.magic2 = magic2;
    header.unknown_6 = 1;
    header.size = sizeof(header) + sizeof(data);
    header.code = code;
  }
};
#pragma pack(pop)

class Gpu {
public:
  Gpu();
  ~Gpu();

  bool Init();
  NTSTATUS Escape(void* data, size_t size);

  D3DKMT_HANDLE adapter_handle() { return adapter_handle_;  }
  D3DKMT_HANDLE device_handle() { return device_handle_; }
  bool CreateContext(D3DKMT_HANDLE* out);
  bool SubmitCommand(D3DKMT_SUBMITCOMMAND* submit_command);
  bool MapGpuVirtualMemory(D3DDDI_MAPGPUVIRTUALADDRESS* map_address);
  bool CreatePagingQueue(D3DKMT_CREATEPAGINGQUEUE* paging_queue);
  bool GetDeviceState(D3DKMT_GETDEVICESTATE* device_state);

private:
  D3DKMT_HANDLE adapter_handle_ = 0;
  D3DKMT_HANDLE device_handle_ = 0;
};

