#include "stdafx.h"
#include "Gpu.h"

#include <ntstatus.h>

namespace {

  D3DKMT_HANDLE InitGpuAdapter(HDC hdc) {
    D3DKMT_OPENADAPTERFROMHDC open_adapter_data = {};
    open_adapter_data.hDc = hdc;
    if (D3DKMTOpenAdapterFromHdc(&open_adapter_data))
      return 0;
    return open_adapter_data.hAdapter;
  }

  D3DKMT_HANDLE CreateGpuDevice(D3DKMT_HANDLE hAdapter) {
    D3DKMT_CREATEDEVICE create_device_data = {};
    create_device_data.hAdapter = hAdapter;
    if (D3DKMTCreateDevice(&create_device_data))
      return 0;

    return create_device_data.hDevice;
  }

}

Gpu::Gpu() {
}

Gpu::~Gpu() {
}

bool Gpu::Init() {
  HDC hdc = GetDC(nullptr);
  adapter_handle_ = InitGpuAdapter(hdc);
  if (!adapter_handle_)
    return false;

  device_handle_ = CreateGpuDevice(adapter_handle_);
  if (!device_handle_)
    return false;

  return true;
}

NTSTATUS Gpu::Escape(void* data, size_t size) {
  D3DKMT_ESCAPE escape_data = {};
  escape_data.hAdapter = adapter_handle_;
  escape_data.hDevice = device_handle_;
  escape_data.pPrivateDriverData = data;
  escape_data.PrivateDriverDataSize = static_cast<UINT>(size);

  return D3DKMTEscape(&escape_data);
}

bool Gpu::CreateContext(D3DKMT_HANDLE* out) {
	D3DKMT_CREATECONTEXTVIRTUAL create_context_virtual{};
	create_context_virtual.hDevice = device_handle_;

	if (D3DKMTCreateContextVirtual(&create_context_virtual) != STATUS_SUCCESS) {
		fprintf(stderr, "Failed to create context.\n");
		return false;
	}

	*out = create_context_virtual.hContext;
	return true;
}

bool Gpu::SubmitCommand(D3DKMT_SUBMITCOMMAND* submit_command) {
	if (D3DKMTSubmitCommand(submit_command) != STATUS_SUCCESS) {
		fprintf(stderr, "Failed to submit command.\n");
		return false;
	}

	return true;
}

bool Gpu::MapGpuVirtualMemory(D3DDDI_MAPGPUVIRTUALADDRESS* map_address) {
	NTSTATUS status = D3DKMTMapGpuVirtualAddress(map_address);
	if (status != STATUS_SUCCESS && status != STATUS_PENDING) {
		fprintf(stderr, "Failed to Map GPU address: %d\n", status);
		return false;
	}

	return true;
}

bool Gpu::CreatePagingQueue(D3DKMT_CREATEPAGINGQUEUE* paging_queue) {
	if (D3DKMTCreatePagingQueue(paging_queue) != STATUS_SUCCESS) {
		fprintf(stderr, "Failed to create paging queue.\n");
		return false;
	}
	return true;
}

bool Gpu::GetDeviceState(D3DKMT_GETDEVICESTATE* device_state) {
	if (D3DKMTGetDeviceState(device_state) != STATUS_SUCCESS) {
		fprintf(stderr, "Failed to get device state.\n");
		return false;
	}

	return true;
}