/*
 * Krb5 API Entry point fo encryption/decryption
 * with 3des and rc4
 *
 * Il codice è brutto, ma io ho frett
 */


#include<stdio.h>
#include<string.h>
#include<stdlib.h>
#include<krb5.h>
#include<errno.h>

int encrypt(krb5_keyblock *keyb, int plen, char *plain,
		krb5_keyusage usage, krb5_enc_data *output ){

	krb5_context con;
	krb5_data input;
	int ret;

	input.length = plen;
	input.data = malloc(plen);
	memcpy(input.data, plain, input.length);

	krb5_init_context(&con);
	output->enctype = keyb->enctype;
	krb5_c_encrypt_length(con, keyb->enctype, input.length, &(output->ciphertext.length));
	output->ciphertext.data = malloc(output->ciphertext.length);

	if (ret = krb5_c_encrypt(con, keyb, usage, 0, &input, output)){
		fprintf(stderr,"error encrypting: %d\n", ret);
		return -1;
	}

	krb5_free_context(con);
	return 0;
}

/*
 *
 * */
int decrypt(krb5_keyblock * keyb, krb5_keyusage usage,
		int clen, char* ctext, krb5_data *output)
{
	krb5_context con;
	//krb5_data output;
	krb5_enc_data input;
	int ret;

	input.enctype = keyb->enctype;
	input.ciphertext.length = clen;
	input.ciphertext.data = malloc(clen);
	memcpy(input.ciphertext.data, ctext, clen);

	krb5_init_context(&con);

	if (ret = krb5_c_decrypt(con, keyb, usage, 0, &input, output)){
			fprintf(stderr,"error decrypting, %d\n", ret);
			return -1;
	}

	krb5_free_context(con);
	//free(input.ciphertext.data);
	return 0;

}

