// @i41nbeer
/*
iOS/MacOS sandbox escape due to trusted length field in shared memory used by HID event subsystem

io_hideventsystem is a MIG service which provides proxy access to various HID devices for untrusted
clients. On iOS it's hosted by backboardd and on MacOS by hidd. The actual implementation is
in IOKit.framework.

I, and also pangu jailbreak team, had previously found a few bugs in the kernel IODataQueue code.
It seems that io_hideventsystem also uses IODataQueues purely in userspace. That is, via shared
memory between two userspace processes rather than between a userspace process and the kernel.

It turns out that the userspace code for enqueuing and dequeuing from an IODataQueue has none
of the hardening that the kernel code now has, so it's trivial to just replace the length, head
and tail fields (which are in a header at the start of the shared memory buffer) such that
the remote process tries to enqueue outside of the bounds of the IODataQueue's actual backing
buffer.

This is a very basic PoC thrown together to minimally repro the issue.

Run build.sh and run.sh, use the mouse a bit and notice the hidd crash log. Don't try to attach lldb to hidd, you will
struggle to interact with it!

Specifically the server will allocate a buffer wrapped by a mach port (via mach_make_memory_entry_64)
then in the client you can see inside IOHIDEventQueueCreateWithVM the port's memory being mapped.

The attached dylib just interposes mach_vm_map to replace the size and tail fields once the shared
memory is mapped in the client.

I've also tested this on iOS just manually manipulating the shared memory after it's mapped.

Depending on how clients use io_hideventsystem it might be possible to hop first in to backboardd
then in to another client (if that client is also enqueuing events into a queue) but that will
take some more research.

Tested on MacOS 10.13.6 and iOS 11.3.1 (that's the highest version I have on a device with me right now.)
*/

#include <stdio.h>
#include <stdlib.h>

#include <mach/mach.h>

#include <IOKit/hidsystem/IOHIDEventSystemClient.h>

void* IOHIDEventSystemClientCreate(void*);
void* IOHIDEventSystemClientRegisterEventCallback(void*, void*, void*, void*);

void touch_event(void* target, void* refcon, void* service, void* event) {
  printf("touch event\n");
}


int main(int argc, char** argv) {
  IOHIDEventSystemClientRef es = IOHIDEventSystemClientCreate(kCFAllocatorDefault);
  IOHIDEventSystemClientScheduleWithRunLoop(es, CFRunLoopGetCurrent(), kCFRunLoopDefaultMode);
  IOHIDEventSystemClientRegisterEventCallback(es, touch_event, NULL, NULL);

  CFRunLoopRun();

  return 0;
}
