package BOHTTPD;
use base Exporter;

@EXPORT = qw(is_ms is_ie show_info show_header show_footer show_warning html_escape);

sub is_ms() { $ENV{HTTP_USER_AGENT} =~ /win/i }
sub is_ie() { $ENV{HTTP_USER_AGENT} =~ /MSIE/ }

sub show_header {
  print q<
    <html>
      <head>
        <title>Brown Orifice HTTPD</title>
      </head>
      <body bgcolor="#ffffff">
      <link rel="stylesheet" href="BOHTTPD.css">
  >;

  if (open my $fp, 'BOHTTPD_logo.html') {
    print while <$fp>;
    close $fp;
  };
}

sub show_info {
  print q<
    <h3>Brown Orifice HTTPD</h3>
    <ul>
    <p>
       I've discovered a pair of new capbilities in Java, one residing
       in the Java core and the other in Netscape's Java distribution.
       The first (exploited in
       BOServerSocket and BOSocket) allows Java to open a server
       which can be accessed by arbitrary clients.  The second
       (BOURLConnection and BOURLInputStream) allows Java to access
       arbitrary URLs, including local files.
    </p>

    <p>
      As a demonstration, I've written Brown Orifice HTTPD for Netscape
      Communicator.  BOHTTPD is a browser-resident
      web server and file-sharing tool that demonstrates these
      two problems in Netscape 
      Communicator. BOHTTPD will serve files from a directory
      of your choice, and will also act as an HTTP/FTP proxy
      server.
    </p>

    <p>
      Click the button below to launch BOHTTPD in your Netscape Browser.
      To see a list of links to browsers currently running BOHTTPD, check out
      <a href="BOHTTPD_spy.cgi">BOHTTPD Spy</a>.  To get a copy of
      the Brown Orifice site and source code, go to the
      <a href="BOHTTPD_download.cgi">download page</a>.
    </p>
     

    <p><i><a href="http://www.brumleve.com/resume.html">Dan Brumleve</a></i> <code>&lt;<a href="mailto:dan%2Bsecurity@brumleve.com">dan+security@brumleve.com</a>&gt;</code>, <code>2000-08-03</code></p>
    </ul>
    <hr>
  >;
}

sub show_warning {
  print q<
    <p><font size=+1 color=red><blink>WARNING:</blink></font>
      Brown Orifice is a <font color=red>SECURITY HOLE</font>,
      not a toy.  You must completely exit Netscape in order
      to turn it off.
    </p>
  >;
}

sub show_footer {
  print q<
    <hr>
    <p><i><a href="http://www.brumleve.com/resume.html">Dan Brumleve</a></i> <code>&lt;<a href="mailto:dan%2Bsecurity@brumleve.com">dan+security@brumleve.com</a>&gt;</code>, <code>2000-08-03</code></p>
      </body>
    </html>
  >
}

sub html_escape {
  local $_ = shift;
  s/&/&amp;/g;
  s/"/&quot;/g;
  s/</&lt;/g;
  s/>/&gt;/g;
  $_
}

1;
