#ifndef xpc_poc_h
#define xpc_poc_h

#include <stdio.h>

#define XPC_CONNECTION_MACH_SERVICE_PRIVILEGED (1 << 1)

typedef void* xpc_connection_t;
typedef void* xpc_object_t;
typedef void* xpc_type_t;

xpc_connection_t xpc_connection_create_mach_service(char*, void*, int);
void xpc_connection_set_event_handler(xpc_connection_t, void (^)(xpc_object_t object));
xpc_object_t xpc_dictionary_get_string(xpc_object_t, char*);
char* xpc_copy_description(xpc_object_t);

void xpc_connection_send_message(xpc_connection_t, xpc_object_t);
xpc_object_t xpc_connection_send_message_with_reply_sync(xpc_connection_t connection, xpc_object_t message);

extern const char * const _xpc_error_key_description;
extern void* _xpc_type_error;

xpc_type_t xpc_get_type(xpc_object_t);
void xpc_connection_resume(xpc_connection_t);
void xpc_release(xpc_object_t);

xpc_object_t xpc_dictionary_create(void*, void*, size_t);
void xpc_dictionary_set_uint64(xpc_object_t dictionary, const char *key, uint64_t value);
void xpc_dictionary_set_int64(xpc_object_t dictionary, const char *key, int64_t value);
void xpc_dictionary_set_data(xpc_object_t dictionary, const char *key, const void *value, size_t length);
void xpc_dictionary_set_value(xpc_object_t dictionary, const char *key, xpc_object_t value);
int xpc_dictionary_dup_fd(xpc_object_t dictionary, const char* key);
uint64_t xpc_dictionary_get_uint64(xpc_object_t dictionary, const char* key);


xpc_connection_t connect_to_xpc_service();

void run_poc();

#endif /* xpc_poc_h */
