/**
*
* PCAUSA Rawether for Windows local privilege escalation
*
* Copyright (c) 2017 ReWolf
* http://blog.rewolf.pl/
* http://blog.rewolf.pl/blog/?p=1778
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published
* by the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/
#include "Helpers.h"
#include <iphlpapi.h>
#include <TlHelp32.h>

#pragma comment(lib, "IPHLPAPI.lib")

template <typename T>
using SmartPtr = std::unique_ptr<T, decltype(&free)>;

std::string whoami()
{
	HANDLE hToken;
	if (!OpenProcessToken(GetCurrentProcess(), TOKEN_QUERY, &hToken))
		return "";
	SmartHANDLE hTokenSmart(hToken, &CloseHandle);

	DWORD tokenLen = 0;
	GetTokenInformation(hToken, TokenUser, nullptr, 0, &tokenLen);
	if (GetLastError() != ERROR_INSUFFICIENT_BUFFER)
		return "";

	SmartPtr<TOKEN_USER> tokenPtr((TOKEN_USER*)malloc(tokenLen), &free);
	if (nullptr == tokenPtr.get())
		return "";

	if (!GetTokenInformation(hToken, TokenUser, tokenPtr.get(), tokenLen, &tokenLen))
		return "";

	SID_NAME_USE SidType;
	char lpName[256];
	char lpDomain[sizeof(lpName)];

	DWORD dwSize = sizeof(lpName);
	if (!LookupAccountSidA(NULL, tokenPtr.get()->User.Sid, lpName, &dwSize, lpDomain, &dwSize, &SidType))
		return "";

	return std::string(lpDomain) + "\\" + lpName;
}

uint32_t getProcessPid(const wchar_t* processName)
{
	SmartHANDLE toolhelp(CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0), &CloseHandle);
	if (INVALID_HANDLE_VALUE == toolhelp.get())
		return 0;
	PROCESSENTRY32 procEntry = { 0 };
	procEntry.dwSize = sizeof(procEntry);
	if (Process32First(toolhelp.get(), &procEntry))
	{
		do
		{
			if (0 == _wcsicmp(procEntry.szExeFile, processName))
			{
				return procEntry.th32ProcessID;
			}
		} while (Process32Next(toolhelp.get(), &procEntry));
	}
	return 0;
}

ForEachNetworkAdapterStatus forEachNetworkAdapter(std::function<bool(const std::wstring&)> f)
{
	ULONG size = 0;
	if (ERROR_BUFFER_OVERFLOW != GetAdaptersInfo(nullptr, &size))
	{
		return ForEachNetworkAdapterStatus::ErrorGetAdapterInfo1;
	}

	SmartPtr<IP_ADAPTER_INFO> adapterInfo((IP_ADAPTER_INFO*)malloc(size), &free);
	if (nullptr == adapterInfo.get())
	{
		return ForEachNetworkAdapterStatus::ErrorMalloc;
	}

	if (ERROR_SUCCESS != GetAdaptersInfo(adapterInfo.get(), &size))
	{
		return ForEachNetworkAdapterStatus::ErrorGetAdapterInfo2;
	}

	IP_ADAPTER_INFO* currentAdapter = adapterInfo.get();
	while (nullptr != currentAdapter)
	{
		std::string tmp(currentAdapter->AdapterName);
		if (f(L"\\DEVICE\\" + std::wstring(tmp.begin(), tmp.end())))
			return ForEachNetworkAdapterStatus::Success;

		currentAdapter = currentAdapter->Next;
	}
	return ForEachNetworkAdapterStatus::ErrorFailure;
}
