#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>

#include "fimg2d.h"

int main() {
  printf("Messing with fimg2d driver\n");
  
  int ret;

  int driver_fd;
  driver_fd = open("/dev/fimg2d", O_RDWR);
  printf("driver_fd %d\n", driver_fd);

  struct fimg2d_version ver;
  memset(&ver, 0xFF, sizeof(ver));

  ret = ioctl(driver_fd, FIMG2D_BITBLT_VERSION, &ver);
  if(ret) {
    printf("Failed to get version %d\n", ret);
    return -1;
  }

  printf("Version %u %u\n", ver.hw, ver.sw);


  struct fimg2d_blit blit;

  memset(&blit, 0x00, sizeof(blit));


  struct fimg2d_image dst_image;
  dst_image.addr.type = ADDR_USER;
  dst_image.width = 10;
  dst_image.height = 10;
  dst_image.rect.x1 = 0;
  dst_image.rect.y1 = 0;
  dst_image.rect.x2 = 5;
  dst_image.rect.y2 = 5;


  blit.op = BLIT_OP_SOLID_FILL;
  blit.dst = &dst_image;

  blit.param.clipping.enable = 0;


  if(fork()) {
    ret = ioctl(driver_fd, FIMG2D_BITBLT_BLIT, &blit);
    printf("BLIT ret %d %d %s\n", ret, errno, strerror(errno));
  } else {
    ret = ioctl(driver_fd, FIMG2D_BITBLT_BLIT, NULL);
    printf("BLIT ret %d %d %s\n", ret, errno, strerror(errno));
  }


  close(driver_fd);
  return 0;
}