#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

static unsigned int print_count = 0;

/* 
 * Error cheq'n wrapper for malloc.
 */
void *Malloc(size_t n)
{
    void *tmp;
    
    if((tmp = malloc(n)) == NULL)
    {
        fprintf(stderr, "malloc(%u) failed! exiting...\n", n);
        exit(EXIT_FAILURE);
    }

    return tmp;
}

/*
 * Error cheq'n realloc.
 */
void *Realloc(void *ptr, size_t n)
{
    void *tmp;
    
    if((tmp = realloc(ptr, n)) == NULL)
    {
        fprintf(stderr, "realloc(%u) failed! exiting...\n", n);
        exit(EXIT_FAILURE);
    }

    return tmp;
}

/* 
 * Just a fun print wrapper.
 */
void print_err(char *fmt, ...)
{
    va_list arglist;
    
    fprintf(stderr, "[-] ");

    va_start(arglist, fmt);
    vfprintf(stderr, fmt, arglist);
    va_end(arglist);

    fflush(stderr);
}

/*
 * Ditto.
 */
void print_msg(char *fmt, ...)
{
    va_list arglist;
    
    fprintf(stdout, "[%u] ", print_count++);

    va_start(arglist, fmt);
    vfprintf(stdout, fmt, arglist);
    va_end(arglist);

    fflush(stdout);
}    
