#include "ximage.h"

/* identifies an mrf image file */
#define MRF_ID_LEN sizeof(mrf_id)
u_char mrf_id[] = { 'M', 'R', 'F', '1' };

/*
 */
#define MRF_HDR_LEN sizeof(mrf_t)
struct _mrf_t {
    u_char  id[4];
    uint32_t    width, height;
    u_char  z;
} __attribute__((packed));
typedef struct _mrf_t mrf_t;


/* */
int ximage_mrf_init(ximage_t *xp)
{
    return 0;
}

/* */
int ximage_mrf_clean(ximage_t *xp)
{
    free(xp->buf);
    return 0;
}

/* */
int ximage_mrf_fill(ximage_t *xp)
{
    int len = 0;
    u_char  buf[BS];
    mrf_t   mrfh;

    /* setup mrf header */
    memset(&mrfh, 0, MRF_HDR_LEN);
    memcpy(&mrfh.id, mrf_id, MRF_ID_LEN);
    mrfh.width = htonl(0x800000);
    mrfh.height = htonl(0x800000);

    memcpy(buf, &mrfh, MRF_HDR_LEN);
    len += MRF_HDR_LEN;
    memset(buf+len, 'Z', 512);
    len += 512;

    /* alloc output buffer */
    xp->buf = calloc(1, len);
    if(xp->buf == NULL)
        die("calloc");
    xp->buflen = len;
 
    memcpy(xp->buf, buf, len);
    return 0;
}
