#include "ximage.h"


/* */
#define GIFH_SZ sizeof(struct _gifh)
typedef struct _gifh
{
  char sig[6];           /* should be GIF87a or GIF89a */
  u_char wide_lo,wide_hi;  /* NUXI Problem Avoidance System (tm) */
  u_char high_lo,high_hi;  /* these are 'screen size', BTW */
  u_char misc;             /* misc, and bpp */
  u_char back;             /* background index */
  u_char zero;             /* if this ain't zero, problem */
} gifh_t;
  
 
/* */
#define GIFB_SZ sizeof(struct _gifb)
typedef struct _gifb
{
  u_char left_lo,left_hi;  /* usually zero - ignore */
  u_char top_lo,top_hi;
  u_char wide_lo,wide_hi;  /* this is 'image size', often the same as screen */
  u_char high_lo,high_hi;
  u_char misc;
} gifb_t;


/* */
int ximage_gif_fill(ximage_t *xp)
{
    int len = 0;
    u_char  buf[BS];
    gifh_t  gh;
    gifb_t  gb;

    memset(buf, 0, BS), memset(&gh, 0, sizeof(gh)), memset(&gb, 0, sizeof(gb));

    /* setup headers */
    snprintf(gh.sig, 6, "%s", "GIF");
    gh.wide_lo = gh.wide_hi = gh.high_lo = gh.high_hi = 0x20;
    gb.wide_lo = gb.wide_hi = gb.high_lo = gb.high_hi = 0x00;


    /* alloc output buffer */
    len = GIFH_SZ + GIFB_SZ + 512 + 1;
    xp->buf = calloc(1, len);
    if(xp->buf == NULL)
        die("calloc");

    xp->buflen = len;
    
    /* copyu out dta */
    //memset(buf, 'A', 512);
    memcpy(xp->buf, &gh, GIFH_SZ);
    xp->buf[GIFH_SZ] = ',';
    memcpy(xp->buf+1+GIFH_SZ, &gb, GIFB_SZ);
    xp->buf[GIFH_SZ+1] = 32;
    memcpy(xp->buf+1+GIFH_SZ+GIFB_SZ, buf, 512);
    
    return 0;
}

/* */
int ximage_gif_clean(ximage_t *xp)
{
    free(xp->buf);
    return 0;
}

/* */
int ximage_gif_init(ximage_t *xp)
{
    return 0;
}
